/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.repository.elasticsearch;

import io.dataintell.visionapi.domain.IndexType;
import io.dataintell.visionapi.domain.search.DateFilter;
import io.dataintell.visionapi.domain.search.LongFilter;
import io.dataintell.visionapi.domain.search.SearchFilter;
import io.dataintell.visionapi.domain.search.StringFilter;
import io.dataintell.visionapi.permission.ResourceFilterBuilder;
import io.dataintell.visionapi.security.AuthenticationHelper;
import io.dataintell.visionapi.utils.ESFileQueryUtils;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.RegexpQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class FileSearchRepository {
    private static final Logger log = LoggerFactory.getLogger(FileSearchRepository.class);
    private final RestHighLevelClient elasticsearchClient;
    private final ESFileQueryUtils esFileQueryUtils;
    private final ResourceFilterBuilder resourceFilterBuilder;
    @Value(value="${app.scrollTimeToLive}")
    private Integer scrollTimeToLive;

    public FileSearchRepository(RestHighLevelClient elasticsearchClient, ESFileQueryUtils esFileQueryUtils, ResourceFilterBuilder resourceFilterBuilder) {
        this.elasticsearchClient = elasticsearchClient;
        this.esFileQueryUtils = esFileQueryUtils;
        this.resourceFilterBuilder = resourceFilterBuilder;
    }

    public Optional<SearchResponse> search(LocalDate indexingDate, Integer page, Integer size, String sort, SortOrder sortOrder, List<SearchFilter> searchFilters) {
        BoolQueryBuilder boolQueryBuilder = this.getBoolQueryBuilderForSearch(searchFilters);
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getSearchRequest((QueryBuilder)boolQueryBuilder, sort, sortOrder, page, size, Boolean.valueOf(true), indexName);
        try {
            return Optional.of(this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public Optional<SearchResponse> searchAfterWithScroll(String searchAfter) {
        SearchScrollRequest searchScrollRequest = new SearchScrollRequest(searchAfter).scroll(new TimeValue((long)this.scrollTimeToLive.intValue()));
        try {
            return Optional.of(this.elasticsearchClient.scroll(searchScrollRequest, RequestOptions.DEFAULT));
        }
        catch (IOException | ElasticsearchException e) {
            return Optional.empty();
        }
    }

    public Optional<SearchResponse> searchWithScroll(LocalDate indexingDate, Integer size, String sort, SortOrder sortOrder, List<SearchFilter> searchFilters) {
        BoolQueryBuilder boolQueryBuilder = this.getBoolQueryBuilderForSearch(searchFilters);
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getScrollSearchRequest((QueryBuilder)boolQueryBuilder, sort, sortOrder, this.scrollTimeToLive, size, indexName);
        try {
            return Optional.of(this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT));
        }
        catch (IOException | ElasticsearchException e) {
            return Optional.empty();
        }
    }

    private BoolQueryBuilder getBoolQueryBuilderForSearch(List<SearchFilter> searchFilters) {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.FILE);
        List<SearchFilter> mustNotFilters = searchFilters.stream().filter(searchFilter -> searchFilter.getExcludeFilter() != null && searchFilter.getExcludeFilter() != false).collect(Collectors.toList());
        List<SearchFilter> shouldFilters = searchFilters.stream().filter(searchFilter -> searchFilter.getExcludeFilter() == null || searchFilter.getExcludeFilter() == false).collect(Collectors.toList());
        mustNotFilters.forEach(searchFilter -> {
            BoolQueryBuilder mustNotBoolQuery = this.getBoolQueryBuilderFromSearchFilter(searchFilter);
            boolQueryBuilder.mustNot((QueryBuilder)mustNotBoolQuery);
        });
        shouldFilters.forEach(searchFilter -> {
            BoolQueryBuilder shouldBoolQuery = this.getBoolQueryBuilderFromSearchFilter(searchFilter);
            boolQueryBuilder.should((QueryBuilder)shouldBoolQuery);
        });
        boolQueryBuilder.minimumShouldMatch(1);
        return boolQueryBuilder;
    }

    private BoolQueryBuilder getBoolQueryBuilderFromSearchFilter(SearchFilter searchFilter) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        if (searchFilter.getMatch() != null) {
            boolQueryBuilder.filter((QueryBuilder)new QueryStringQueryBuilder(searchFilter.getMatch()));
        }
        boolQueryBuilder = this.updateBoolQueryBuilderWithStringFilter(boolQueryBuilder, searchFilter.getFileId(), "fileId");
        boolQueryBuilder = this.updateBoolQueryBuilderWithStringFilter(boolQueryBuilder, searchFilter.getName(), "name");
        boolQueryBuilder = this.updateBoolQueryBuilderWithStringFilter(boolQueryBuilder, searchFilter.getPath(), "path");
        boolQueryBuilder = this.updateBoolQueryBuilderWithStringFilter(boolQueryBuilder, searchFilter.getOwner(), "owner");
        boolQueryBuilder = this.updateBoolQueryBuilderWithStringFilter(boolQueryBuilder, searchFilter.getGroup(), "group");
        boolQueryBuilder = this.updateBoolQueryBuilderWithStringFilter(boolQueryBuilder, searchFilter.getIdentificationHash(), "identificationHash");
        boolQueryBuilder = this.updateBoolQueryBuilderWithStringFilter(boolQueryBuilder, searchFilter.getExtension(), "extension");
        boolQueryBuilder = this.updateBoolQueryBuilderWithStringFilter(boolQueryBuilder, searchFilter.getVolumeName(), "volumeName");
        if (searchFilter.getCustomTags() != null) {
            for (StringFilter searchFilterCustomTag : searchFilter.getCustomTags()) {
                boolQueryBuilder = this.updateBoolQueryBuilderWithStringFilter(boolQueryBuilder, searchFilterCustomTag, "customTag");
            }
        }
        boolQueryBuilder = this.updateBoolQueryBuilderWithLongFilter(boolQueryBuilder, searchFilter.getSize(), "size");
        boolQueryBuilder = this.updateBoolQueryBuilderWithLongFilter(boolQueryBuilder, searchFilter.getVolumeId(), "volumeId");
        boolQueryBuilder = this.updateBoolQueryBuilderWithLongFilter(boolQueryBuilder, searchFilter.getInode(), "inode");
        boolQueryBuilder = this.updateBoolQueryBuilderWithLongFilter(boolQueryBuilder, searchFilter.getNumberOfFiles(), "numberOfFiles");
        boolQueryBuilder = this.updateBoolQueryBuilderWithLongFilter(boolQueryBuilder, searchFilter.getNumberOfFolders(), "numberOfFolders");
        if (searchFilter.getNumericNameList() != null) {
            for (LongFilter searchFilterNumericValue : searchFilter.getNumericNameList()) {
                boolQueryBuilder = this.updateBoolQueryBuilderWithLongFilter(boolQueryBuilder, searchFilterNumericValue, "numericNameList");
            }
        }
        boolQueryBuilder = this.updateBoolQueryBuilderWithDateFilter(boolQueryBuilder, searchFilter.getLastModifiedDate(), "lastModified");
        boolQueryBuilder = this.updateBoolQueryBuilderWithDateFilter(boolQueryBuilder, searchFilter.getLastAccessDate(), "lastAccess");
        boolQueryBuilder = this.updateBoolQueryBuilderWithDateFilter(boolQueryBuilder, searchFilter.getCreationDate(), "creationDate");
        boolQueryBuilder = this.updateBoolQueryBuilderWithDateFilter(boolQueryBuilder, searchFilter.getIndexingDate(), "indexingDate");
        if (searchFilter.getIsDupe() != null) {
            boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDupe", (Object)searchFilter.getIsDupe()));
        }
        if (searchFilter.getIsDirectory() != null) {
            boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDirectory", (Object)searchFilter.getIsDirectory()));
        }
        if (searchFilter.getIsDeleted() != null) {
            boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDeleted", (Object)searchFilter.getIsDeleted()));
        }
        return boolQueryBuilder;
    }

    private BoolQueryBuilder updateBoolQueryBuilderWithStringFilter(BoolQueryBuilder boolQueryBuilder, StringFilter stringFilter, String fieldName) {
        if (stringFilter == null) {
            return boolQueryBuilder;
        }
        if (stringFilter.getValue() != null) {
            boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder(fieldName, stringFilter.getValue()));
        }
        if (stringFilter.getWildcard() != null) {
            boolQueryBuilder.filter((QueryBuilder)new WildcardQueryBuilder(fieldName, stringFilter.getWildcard()));
        }
        if (stringFilter.getStartingWith() != null) {
            boolQueryBuilder.filter((QueryBuilder)new PrefixQueryBuilder(fieldName, stringFilter.getStartingWith()));
        }
        if (stringFilter.getRegex() != null) {
            boolQueryBuilder.filter((QueryBuilder)new RegexpQueryBuilder(fieldName, stringFilter.getRegex()));
        }
        if (stringFilter.getValues() != null) {
            boolQueryBuilder.filter((QueryBuilder)new TermsQueryBuilder(fieldName, (Iterable)stringFilter.getValues()));
        }
        return boolQueryBuilder;
    }

    private BoolQueryBuilder updateBoolQueryBuilderWithLongFilter(BoolQueryBuilder boolQueryBuilder, LongFilter longFilter, String fieldName) {
        if (longFilter == null) {
            return boolQueryBuilder;
        }
        if (longFilter.getValue() != null) {
            boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder(fieldName, (Object)longFilter.getValue()));
        }
        if (longFilter.getValues() != null) {
            boolQueryBuilder.filter((QueryBuilder)new TermsQueryBuilder(fieldName, (Iterable)longFilter.getValues()));
        }
        if (longFilter.getMin() != null) {
            boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder(fieldName).gte((Object)longFilter.getMin()));
        }
        if (longFilter.getMax() != null) {
            boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder(fieldName).lte((Object)longFilter.getMax()));
        }
        return boolQueryBuilder;
    }

    private BoolQueryBuilder updateBoolQueryBuilderWithDateFilter(BoolQueryBuilder boolQueryBuilder, DateFilter dateFilter, String fieldName) {
        if (dateFilter == null) {
            return boolQueryBuilder;
        }
        if (dateFilter.getAfter() != null) {
            boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder(fieldName).gte((Object)dateFilter.getAfter()));
        }
        if (dateFilter.getBefore() != null) {
            boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder(fieldName).lte((Object)dateFilter.getBefore()));
        }
        return boolQueryBuilder;
    }
}

