/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.repository.elasticsearch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.dataintell.visionapi.domain.DateIntervalType;
import io.dataintell.visionapi.domain.ESListener;
import io.dataintell.visionapi.domain.File;
import io.dataintell.visionapi.domain.IndexType;
import io.dataintell.visionapi.permission.ResourceFilterBuilder;
import io.dataintell.visionapi.repository.elasticsearch.FileRepository;
import io.dataintell.visionapi.security.AuthenticationHelper;
import io.dataintell.visionapi.utils.ESFileQueryUtils;
import io.dataintell.visionapi.utils.ESSearchFileUtils;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class FileRepository {
    private static final Logger log = LoggerFactory.getLogger(FileRepository.class);
    private final RestHighLevelClient elasticsearchClient;
    private final ESFileQueryUtils esFileQueryUtils;
    private final ESSearchFileUtils esSearchFileUtils;
    private final ResourceFilterBuilder resourceFilterBuilder;

    public FileRepository(RestHighLevelClient elasticsearchClient, ESFileQueryUtils esFileQueryUtils, ESSearchFileUtils esSearchFileUtils, ResourceFilterBuilder resourceFilterBuilder) {
        this.elasticsearchClient = elasticsearchClient;
        this.esFileQueryUtils = esFileQueryUtils;
        this.esSearchFileUtils = esSearchFileUtils;
        this.resourceFilterBuilder = resourceFilterBuilder;
    }

    public SearchResponse getNextListWithScroll(String scrollId, Integer timeToLive) throws IOException {
        SearchScrollRequest searchScrollRequest = new SearchScrollRequest(scrollId).scroll(new TimeValue((long)timeToLive.intValue()));
        return this.elasticsearchClient.scroll(searchScrollRequest, RequestOptions.DEFAULT);
    }

    public void clearScroll(String scrollId) {
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        try {
            this.elasticsearchClient.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            log.error(String.format("Unable to clear scrollId [%s]", scrollId));
        }
    }

    public SearchResponse searchFiles(List<String> searchWords, Boolean onlyDuplicate, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationAfter, LocalDate creationBefore, List<String> extensions, Integer from, Integer size, String fieldSort, SortOrder sortDirection, Long minimumSize, Long maximumSize, Boolean showOnlyDeletedFiles, List<String> volumesAndPaths, List<String> ignorePatterns, List<String> tags, Boolean isDirectory, Long minimumNumberOfFiles, Long maximumNumberOfFiles, Long minimumNumberOfFolders, Long maximumNumberOfFolders, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQuery = this.esSearchFileUtils.getInitialBoolQueryBuilderForSearch(onlyDuplicate, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, minimumSize, maximumSize, isDirectory, showOnlyDeletedFiles, volumesAndPaths, ignorePatterns, tags, searchWords, minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders);
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getSearchRequest((QueryBuilder)boolQuery, fieldSort, sortDirection, from, size, Boolean.valueOf(true), indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse searchFilesWithScroll(List<String> searchWords, Boolean onlyDuplicate, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationAfter, LocalDate creationBefore, List<String> extensions, Integer size, Integer timeToLive, String fieldSort, SortOrder sortDirection, Long minimumSize, Long maximumSize, Boolean showOnlyDeletedFiles, List<String> volumesAndPaths, List<String> ignorePatterns, List<String> tags, Boolean isDirectory, Long minimumNumberOfFiles, Long maximumNumberOfFiles, Long minimumNumberOfFolders, Long maximumNumberOfFolders, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQuery = this.esSearchFileUtils.getInitialBoolQueryBuilderForSearch(onlyDuplicate, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, minimumSize, maximumSize, isDirectory, showOnlyDeletedFiles, volumesAndPaths, ignorePatterns, tags, searchWords, minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders);
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getScrollSearchRequest((QueryBuilder)boolQuery, fieldSort, sortDirection, timeToLive, size, indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getSumAndTotalOfAField(List<String> searchWords, Boolean onlyDuplicate, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationAfter, LocalDate creationBefore, List<String> extensions, String fieldName, Long minimumSize, Long maximumSize, Boolean showOnlyDeletedFiles, Integer size, List<String> volumesAndPaths, List<String> ignorePatterns, List<String> tags, Boolean isDirectory, Long minimumNumberOfFiles, Long maximumNumberOfFiles, Long minimumNumberOfFolders, Long maximumNumberOfFolders, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQuery = this.esSearchFileUtils.getInitialBoolQueryBuilderForSearch(onlyDuplicate, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, minimumSize, maximumSize, isDirectory, showOnlyDeletedFiles, volumesAndPaths, ignorePatterns, tags, searchWords, minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders);
        ArrayList<AbstractAggregationBuilder> aggregationBuilders = new ArrayList<AbstractAggregationBuilder>();
        aggregationBuilders.add(((TermsAggregationBuilder)AggregationBuilders.terms((String)"fieldName").field(fieldName)).size(size.intValue()).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"size").field("size")));
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getSearchRequestWithAggregation((QueryBuilder)boolQuery, "name", SortOrder.ASC, Integer.valueOf(0), Integer.valueOf(0), Boolean.valueOf(false), aggregationBuilders, indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public void addTagToFiles(List<String> fileIds, String tag, LocalDate currentScanDate) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.filter((QueryBuilder)new TermsQueryBuilder("fileId", fileIds));
        UpdateByQueryRequest request = new UpdateByQueryRequest(new String[]{ESFileQueryUtils.getIndexName((LocalDate)currentScanDate)});
        request.setQuery((QueryBuilder)boolQueryBuilder);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customTag", tag);
        Script script = new Script(Script.DEFAULT_SCRIPT_TYPE, "painless", "if (ctx._source.customTag == null) {ctx._source.customTag = new ArrayList(); ctx._source.customTag.add(params.customTag);} else if (!ctx._source.customTag.contains(params.customTag)) {ctx._source.customTag.add(params.customTag);}", params);
        request.setScript(script);
        request.setAbortOnVersionConflict(false);
        request.setSlices(4);
        request.setRefresh(true);
        try {
            this.elasticsearchClient.updateByQuery(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            log.error("There was an issue while updating files with tag [{}]", (Object)tag);
        }
    }

    public void addTagForSearch(List<String> searchWords, Boolean onlyDuplicate, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationAfter, LocalDate creationBefore, List<String> extensions, Long minimumSize, Long maximumSize, Boolean showOnlyDeletedFiles, List<String> volumesAndPaths, List<String> ignorePatterns, List<String> tags, Boolean isDirectory, Long minimumNumberOfFiles, Long maximumNumberOfFiles, Long minimumNumberOfFolders, Long maximumNumberOfFolders, LocalDate indexingDate, String tag) {
        BoolQueryBuilder boolQuery = this.esSearchFileUtils.getInitialBoolQueryBuilderForSearch(onlyDuplicate, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, minimumSize, maximumSize, isDirectory, showOnlyDeletedFiles, volumesAndPaths, ignorePatterns, tags, searchWords, minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders);
        boolQuery.mustNot((QueryBuilder)new TermQueryBuilder("customTag", tag));
        UpdateByQueryRequest request = new UpdateByQueryRequest(new String[]{ESFileQueryUtils.getIndexName((LocalDate)indexingDate)});
        request.setQuery((QueryBuilder)boolQuery);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customTag", tag);
        Script script = new Script(Script.DEFAULT_SCRIPT_TYPE, "painless", "if (ctx._source.customTag == null) {ctx._source.customTag = new ArrayList();} ctx._source.customTag.add(params.customTag)", params);
        request.setScript(script);
        request.setAbortOnVersionConflict(false);
        request.setSlices(4);
        request.setRefresh(true);
        try {
            BulkByScrollResponse bulkByScrollResponse = this.elasticsearchClient.updateByQuery(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SearchResponse getSizeOfSearchedFiles(List<String> searchWords, Boolean onlyDuplicate, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationAfter, LocalDate creationBefore, List<String> extensions, Long minimumSize, Long maximumSize, Boolean showOnlyDeletedFiles, List<String> volumesAndPaths, List<String> ignorePatterns, List<String> tags, Boolean isDirectory, Long minimumNumberOfFiles, Long maximumNumberOfFiles, Long minimumNumberOfFolders, Long maximumNumberOfFolders, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQuery = this.esSearchFileUtils.getInitialBoolQueryBuilderForSearch(onlyDuplicate, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, minimumSize, maximumSize, isDirectory, showOnlyDeletedFiles, volumesAndPaths, ignorePatterns, tags, searchWords, minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders);
        ArrayList<ValuesSourceAggregationBuilder> aggregationBuilders = new ArrayList<ValuesSourceAggregationBuilder>();
        aggregationBuilders.add(AggregationBuilders.sum((String)"size").field("size"));
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getSearchRequestWithAggregation((QueryBuilder)boolQuery, "name", SortOrder.ASC, Integer.valueOf(0), Integer.valueOf(0), Boolean.valueOf(false), aggregationBuilders, indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getDateHistogramBasedOnSearch(List<String> searchWords, Boolean onlyDuplicate, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationAfter, LocalDate creationBefore, List<String> extensions, String dateField, Long minimumSize, Long maximumSize, Boolean showOnlyDeletedFiles, DateIntervalType dateIntervalType, Integer size, List<String> volumesAndPaths, List<String> ignorePatterns, List<String> tags, Boolean isDirectory, Long minimumNumberOfFiles, Long maximumNumberOfFiles, Long minimumNumberOfFolders, Long maximumNumberOfFolders, LocalDate indexingDate) throws IOException {
        switch (dateField) {
            case "creationDate": {
                creationBefore = this.getDateBefore(creationBefore);
                creationAfter = this.getLocalDateForDateHistogram(creationAfter, creationBefore, size, dateIntervalType, indexingDate);
                break;
            }
            case "lastModified": {
                lastModifiedBefore = this.getDateBefore(lastModifiedBefore);
                lastModifiedAfter = this.getLocalDateForDateHistogram(lastModifiedAfter, lastModifiedBefore, size, dateIntervalType, indexingDate);
                break;
            }
            case "lastAccess": {
                lastAccessBefore = this.getDateBefore(lastAccessBefore);
                lastAccessAfter = this.getLocalDateForDateHistogram(lastAccessAfter, lastAccessBefore, size, dateIntervalType, indexingDate);
                break;
            }
            default: {
                throw new RuntimeException("Invalid date field name");
            }
        }
        DateHistogramInterval dateHistogramInterval = null;
        switch (1.$SwitchMap$io$dataintell$visionapi$domain$DateIntervalType[dateIntervalType.ordinal()]) {
            case 1: {
                dateHistogramInterval = DateHistogramInterval.DAY;
                break;
            }
            case 2: {
                dateHistogramInterval = DateHistogramInterval.WEEK;
                break;
            }
            case 3: {
                dateHistogramInterval = DateHistogramInterval.MONTH;
                break;
            }
            case 4: {
                dateHistogramInterval = DateHistogramInterval.YEAR;
            }
        }
        BoolQueryBuilder boolQuery = this.esSearchFileUtils.getInitialBoolQueryBuilderForSearch(onlyDuplicate, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, minimumSize, maximumSize, isDirectory, showOnlyDeletedFiles, volumesAndPaths, ignorePatterns, tags, searchWords, minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders);
        AbstractAggregationBuilder aggregationBuilder = ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"dateHistogram").field(dateField)).calendarInterval(dateHistogramInterval).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"size").field("size"));
        ArrayList<AbstractAggregationBuilder> aggregationBuilders = new ArrayList<AbstractAggregationBuilder>();
        aggregationBuilders.add(aggregationBuilder);
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getSearchRequestWithAggregation((QueryBuilder)boolQuery, "name", SortOrder.ASC, Integer.valueOf(0), Integer.valueOf(0), Boolean.valueOf(false), aggregationBuilders, indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    private LocalDate getDateBefore(LocalDate dateBefore) {
        if (dateBefore == null) {
            LocalDate today = LocalDate.now();
            return today.withDayOfMonth(today.lengthOfMonth());
        }
        return dateBefore;
    }

    private LocalDate getLocalDateForDateHistogram(LocalDate dateAfter, LocalDate dateBefore, Integer size, DateIntervalType dateIntervalType, LocalDate indexingDate) {
        LocalDate newAfter;
        if (size == null) {
            return dateAfter;
        }
        LocalDate referenceDate = dateBefore == null ? indexingDate : dateBefore;
        switch (1.$SwitchMap$io$dataintell$visionapi$domain$DateIntervalType[dateIntervalType.ordinal()]) {
            case 1: {
                newAfter = referenceDate.minusDays(size.intValue());
                break;
            }
            case 2: {
                newAfter = referenceDate.minusWeeks(size.intValue());
                break;
            }
            case 4: {
                newAfter = referenceDate.minusYears(size.intValue());
                break;
            }
            default: {
                newAfter = referenceDate.minusMonths(size.intValue());
            }
        }
        return dateAfter != null && dateAfter.isAfter(newAfter) ? dateAfter : newAfter;
    }

    public SearchResponse getTotalFileSizeAccessBefore(Date date, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.esFileQueryUtils.getBasicBoolQueryBuilder(Boolean.valueOf(false), null);
        boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("lastAccess").lt((Object)date.getTime()));
        ArrayList<ValuesSourceAggregationBuilder> aggregationBuilders = new ArrayList<ValuesSourceAggregationBuilder>();
        aggregationBuilders.add(AggregationBuilders.sum((String)"size").field("size"));
        aggregationBuilders.add(AggregationBuilders.max((String)"lastAccess").field("lastAccess"));
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getSearchRequestWithAggregation((QueryBuilder)boolQueryBuilder, "name", SortOrder.ASC, Integer.valueOf(0), Integer.valueOf(0), Boolean.valueOf(false), aggregationBuilders, indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getDuplicateFiles(LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.esFileQueryUtils.getBasicBoolQueryBuilder(Boolean.valueOf(false), null);
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDupe", true));
        ArrayList<ValuesSourceAggregationBuilder> aggregationBuilders = new ArrayList<ValuesSourceAggregationBuilder>();
        aggregationBuilders.add(AggregationBuilders.sum((String)"size").field("size"));
        aggregationBuilders.add(AggregationBuilders.max((String)"lastAccess").field("lastAccess"));
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getSearchRequestWithAggregation((QueryBuilder)boolQueryBuilder, "name", SortOrder.ASC, Integer.valueOf(0), Integer.valueOf(0), Boolean.valueOf(true), aggregationBuilders, indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getFilesOfDirectoryIndexedBefore(String path, Long volumeId, Date scanDate, Integer size, LocalDate indexingDate, Integer timeToLive) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.esFileQueryUtils.getBasicBoolQueryBuilder(Boolean.valueOf(false), null);
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"indexingDate").lt((Object)scanDate.getTime()));
        BoolQueryBuilder pathBoolQuery = new BoolQueryBuilder();
        Object formattedPath = path.equals("/") ? path : path + "/";
        pathBoolQuery.should((QueryBuilder)QueryBuilders.prefixQuery((String)"path", (String)formattedPath));
        pathBoolQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"path", (String)path));
        pathBoolQuery.minimumShouldMatch(1);
        boolQueryBuilder.filter((QueryBuilder)pathBoolQuery);
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"volumeId", (Object)volumeId));
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getScrollSearchRequest((QueryBuilder)boolQueryBuilder, "name", SortOrder.ASC, timeToLive, size, indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getFilesOfDirectory(String path, Long volumeId, Integer from, Integer size, String fieldSort, SortOrder sortDirection, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.esFileQueryUtils.getBasicBoolQueryBuilder(Boolean.valueOf(false), null);
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"path", (String)path));
        if (volumeId != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"volumeId", (Object)volumeId));
        }
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getSearchRequest((QueryBuilder)boolQueryBuilder, fieldSort, sortDirection, from, size, Boolean.valueOf(true), indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getFilesOfDirectories(List<String> paths, List<Long> volumeIds, Boolean onlyDuplicates, Boolean onlyArchived, Date lastAccessDate, Integer from, Integer size, String fieldSort, SortOrder sortDirection, Boolean includeSubDirectories, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.esFileQueryUtils.getBasicBoolQueryBuilder(Boolean.valueOf(false), null);
        for (int i = 0; i < paths.size(); ++i) {
            BoolQueryBuilder volumePathBoolQuery = new BoolQueryBuilder();
            BoolQueryBuilder pathBoolQuery = new BoolQueryBuilder();
            if (includeSubDirectories.booleanValue()) {
                Object path = paths.get(i).equals("/") ? paths.get(i) : paths.get(i) + "/";
                pathBoolQuery.should((QueryBuilder)QueryBuilders.prefixQuery((String)"path.tree", (String)path));
            }
            pathBoolQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"path.tree", (String)paths.get(i)));
            pathBoolQuery.minimumShouldMatch(1);
            volumePathBoolQuery.filter((QueryBuilder)pathBoolQuery);
            if (Objects.nonNull(volumeIds) && Objects.nonNull(volumeIds.get(i))) {
                volumePathBoolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"volumeId", (Object)volumeIds.get(i)));
            }
            boolQueryBuilder.should((QueryBuilder)volumePathBoolQuery);
        }
        if (lastAccessDate != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"lastAccess").lt((Object)lastAccessDate.getTime()));
        }
        boolQueryBuilder.minimumShouldMatch("1");
        if (onlyDuplicates.booleanValue()) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"isDupe", (boolean)true));
        }
        if (onlyArchived.booleanValue()) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.existsQuery((String)"archivedDate"));
        }
        ArrayList<ValuesSourceAggregationBuilder> aggregationBuilders = new ArrayList<ValuesSourceAggregationBuilder>();
        aggregationBuilders.add(AggregationBuilders.sum((String)"size").field("size"));
        aggregationBuilders.add(AggregationBuilders.max((String)"lastAccess").field("lastAccess"));
        aggregationBuilders.add(AggregationBuilders.max((String)"lastModified").field("lastModified"));
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getSearchRequestWithAggregation((QueryBuilder)boolQueryBuilder, fieldSort, sortDirection, from, size, Boolean.valueOf(true), aggregationBuilders, indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getFilesByHash(String hash, Integer from, Integer size, String fieldSort, SortOrder sortDirection, LocalDate indexingDate, boolean isDirectory) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.esFileQueryUtils.getBasicBoolQueryBuilder(Boolean.valueOf(isDirectory), Boolean.valueOf(false));
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("identificationHash", hash));
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getSearchRequest((QueryBuilder)boolQueryBuilder, fieldSort, sortDirection, from, size, Boolean.valueOf(true), indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getIdentificationHash(Integer size, String afterKey, Boolean tagDuplicateFiles, LocalDate lastModifiedBefore, LocalDate lastModifiedAfter, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.FILE);
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDeleted", false));
        BoolQueryBuilder fileBoolQueryBuilder = new BoolQueryBuilder();
        fileBoolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDirectory", false));
        BoolQueryBuilder folderBoolQueryBuilder = new BoolQueryBuilder();
        folderBoolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDirectory", true));
        if (lastModifiedAfter != null) {
            fileBoolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("lastModified").gte((Object)lastModifiedAfter.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
            folderBoolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("creationDate").gte((Object)lastModifiedAfter.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        }
        if (lastModifiedBefore != null) {
            fileBoolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("lastModified").lt((Object)lastModifiedBefore.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
            folderBoolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("creationDate").lt((Object)lastModifiedBefore.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        }
        if (tagDuplicateFiles.booleanValue()) {
            boolQueryBuilder.should((QueryBuilder)fileBoolQueryBuilder);
        }
        boolQueryBuilder.should((QueryBuilder)folderBoolQueryBuilder);
        boolQueryBuilder.minimumShouldMatch(1);
        TermsValuesSourceBuilder termsValuesSourceBuilder = (TermsValuesSourceBuilder)new TermsValuesSourceBuilder("identificationHashCount").field("identificationHash");
        HashMap<String, String> aggregationAfter = null;
        if (afterKey != null) {
            aggregationAfter = new HashMap<String, String>();
            aggregationAfter.put("identificationHashCount", afterKey);
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{ESFileQueryUtils.getIndexName((LocalDate)indexingDate)});
        SearchSourceBuilder searchSourceBuilder = this.esFileQueryUtils.getSearchSourceBuilder((QueryBuilder)boolQueryBuilder, "name", SortOrder.ASC, Integer.valueOf(0), Integer.valueOf(0), Boolean.valueOf(false));
        searchSourceBuilder.aggregation((AggregationBuilder)((CompositeAggregationBuilder)AggregationBuilders.composite((String)"my_buckets", Collections.singletonList(termsValuesSourceBuilder)).subAggregation((AggregationBuilder)AggregationBuilders.terms((String)"dupe").field("isDupe"))).size(size.intValue()).aggregateAfter(aggregationAfter));
        searchRequest.source(searchSourceBuilder);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getDuplicateIdentificationHashByVolumeIds(List<Long> volumeIds, LocalDate indexingDate, Boolean onlyDirectory) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.FILE);
        boolQueryBuilder.filter((QueryBuilder)new TermsQueryBuilder("volumeId", volumeIds));
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDeleted", false));
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDupe", false));
        if (onlyDirectory.booleanValue()) {
            boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDirectory", true));
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{ESFileQueryUtils.getIndexName((LocalDate)indexingDate)});
        SearchSourceBuilder searchSourceBuilder = this.esFileQueryUtils.getSearchSourceBuilder((QueryBuilder)boolQueryBuilder, "name", SortOrder.ASC, Integer.valueOf(0), Integer.valueOf(0), Boolean.valueOf(false));
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"identificationHash").field("identificationHash")).minDocCount(2L).size(1000));
        searchRequest.source(searchSourceBuilder);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public Optional<SearchResponse> searchIdentificationHash(List<Long> volumeIds, Boolean isDuplicate, Boolean isDirectory, LocalDate lastModifiedDateBefore, LocalDate lastModifiedDateAfter, LocalDate creationDateBefore, LocalDate creationDateAfter, LocalDate indexingDate) {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.FILE);
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDeleted", false));
        if (volumeIds != null) {
            boolQueryBuilder.filter((QueryBuilder)new TermsQueryBuilder("volumeId", volumeIds));
        }
        if (isDuplicate != null) {
            boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDupe", (Object)isDuplicate));
        }
        if (isDirectory != null) {
            boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDirectory", (Object)isDirectory));
        }
        if (lastModifiedDateAfter != null) {
            boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("lastModified").gte((Object)lastModifiedDateAfter.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        }
        if (lastModifiedDateBefore != null) {
            boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("lastModified").lt((Object)lastModifiedDateBefore.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        }
        if (creationDateAfter != null) {
            boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("creationDate").gte((Object)creationDateAfter.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        }
        if (creationDateBefore != null) {
            boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("creationDate").lt((Object)creationDateBefore.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{ESFileQueryUtils.getIndexName((LocalDate)indexingDate)});
        SearchSourceBuilder searchSourceBuilder = this.esFileQueryUtils.getSearchSourceBuilder((QueryBuilder)boolQueryBuilder, "name", SortOrder.ASC, Integer.valueOf(0), Integer.valueOf(0), Boolean.valueOf(false));
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"identificationHash").field("identificationHash")).minDocCount(2L).size(1000));
        searchRequest.source(searchSourceBuilder);
        try {
            return Optional.of(this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT));
        }
        catch (IOException e) {
            log.warn("There was an error while searching for identificationHash");
            return Optional.empty();
        }
    }

    public void tagDuplicatedFilesByHash(List<String> identificationHashes, Boolean isDuplicated, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.FILE);
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDeleted", false));
        for (String identificationHash : identificationHashes) {
            boolQueryBuilder.should((QueryBuilder)new TermQueryBuilder("identificationHash", identificationHash));
        }
        boolQueryBuilder.minimumShouldMatch(1);
        ESListener listener = new ESListener();
        UpdateByQueryRequest request = new UpdateByQueryRequest(new String[]{ESFileQueryUtils.getIndexName((LocalDate)indexingDate)});
        request.setQuery((QueryBuilder)boolQueryBuilder);
        Script script = new Script("ctx._source.isDupe= '" + isDuplicated + "'");
        request.setScript(script);
        request.setSlices(4);
        request.setRefresh(true);
        this.elasticsearchClient.updateByQueryAsync(request, RequestOptions.DEFAULT, (ActionListener)listener);
        this.waitForListenerResponse(listener);
    }

    public void tagDeletedFilesByVolumesAndOlderThanIndexingDate(List<Long> volumeIds, Date scanDate, LocalDate indexingDate) {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.FILE);
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDeleted", false));
        boolQueryBuilder.filter((QueryBuilder)new TermsQueryBuilder("volumeId", volumeIds));
        boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("indexingDate").lt((Object)scanDate.getTime()));
        ESListener listener = new ESListener();
        UpdateByQueryRequest request = new UpdateByQueryRequest(new String[]{ESFileQueryUtils.getIndexName((LocalDate)indexingDate)});
        request.setQuery((QueryBuilder)boolQueryBuilder);
        request.setScript(new Script("ctx._source.isDeleted= 'true'"));
        request.setSlices(4);
        request.setRefresh(true);
        this.elasticsearchClient.updateByQueryAsync(request, RequestOptions.DEFAULT, (ActionListener)listener);
        this.waitForListenerResponse(listener);
    }

    public void removeDeletedFilesOlderThan(LocalDate date, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.FILE);
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDeleted", true));
        boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("indexingDate").lt((Object)date.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{ESFileQueryUtils.getIndexName((LocalDate)indexingDate)});
        request.setQuery((QueryBuilder)boolQueryBuilder);
        BulkByScrollResponse result = this.elasticsearchClient.deleteByQuery(request, RequestOptions.DEFAULT);
        log.info(String.format("[%s] files and folders were remove from index [%s]", result.getDeleted(), indexingDate));
        if (result.getBulkFailures().size() > 1) {
            log.error(String.format("There was an error to remove deleted file older than [%s] for index [%s]", date, indexingDate));
        }
    }

    public Optional<UpdateResponse> updateById(String id, File file, LocalDate indexingDate) {
        try {
            Gson gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ").create();
            String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
            String source = gsonBuilder.toJson((Object)file);
            UpdateRequest updateRequest = (UpdateRequest)new UpdateRequest(indexName, id).upsert(source, XContentType.JSON).doc(source, XContentType.JSON).setRefreshPolicy("true");
            return Optional.of(this.elasticsearchClient.update(updateRequest, RequestOptions.DEFAULT));
        }
        catch (IOException e) {
            log.error("There was a problem communicating with ES", (Throwable)e);
            return Optional.empty();
        }
    }

    public SearchResponse getTags(Integer size, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.FILE);
        SearchRequest searchRequest = new SearchRequest(new String[]{ESFileQueryUtils.getIndexName((LocalDate)indexingDate)});
        SearchSourceBuilder searchSourceBuilder = this.esFileQueryUtils.getSearchSourceBuilder((QueryBuilder)boolQueryBuilder, "name", SortOrder.ASC, Integer.valueOf(0), Integer.valueOf(0), Boolean.valueOf(false));
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"customTag").field("customTag")).size(size.intValue()));
        searchRequest.source(searchSourceBuilder);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public void deleteFilesFromLatestIndexingDate(Long volumeId, LocalDate indexingDate) throws IOException {
        DeleteByQueryRequest request = (DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{"file-" + indexingDate}).setRefresh(true);
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("volumeId", (Object)volumeId));
        request.setQuery((QueryBuilder)boolQueryBuilder);
        ESListener listener = new ESListener();
        this.elasticsearchClient.deleteByQueryAsync(request, RequestOptions.DEFAULT, (ActionListener)listener);
    }

    private void waitForListenerResponse(ESListener listener) {
        while (!listener.isResponseReturned()) {
            log.debug("Waiting for response...");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.error("Thread.sleep has been interrupted");
            }
        }
        if (listener.getException() != null) {
            log.error(listener.getException());
        }
    }
}

