/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.repository.elasticsearch;

import io.dataintell.visionapi.domain.IndexType;
import io.dataintell.visionapi.permission.ResourceFilterBuilder;
import io.dataintell.visionapi.security.AuthenticationHelper;
import io.dataintell.visionapi.utils.ESFileQueryUtils;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.stereotype.Service;

@Service
public class DirectoryRepository {
    private final RestHighLevelClient elasticsearchClient;
    private final ESFileQueryUtils esFileQueryUtils;
    private final ResourceFilterBuilder resourceFilterBuilder;

    public DirectoryRepository(RestHighLevelClient elasticsearchClient, ESFileQueryUtils esFileQueryUtils, ResourceFilterBuilder resourceFilterBuilder) {
        this.elasticsearchClient = elasticsearchClient;
        this.esFileQueryUtils = esFileQueryUtils;
        this.resourceFilterBuilder = resourceFilterBuilder;
    }

    public SearchResponse getDirectoriesByPath(String path, Integer from, Integer size, String fieldSort, SortOrder sortDirection, Boolean showHiddenDirectories, Long volumeId, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.esFileQueryUtils.getBasicBoolQueryBuilder(Boolean.valueOf(true), null);
        FieldSortBuilder sortBuilder = SortBuilders.fieldSort((String)fieldSort);
        sortBuilder.order(sortDirection);
        String regexPath = path.equals("/") ? "/[^/]*" : String.format("%s/[^/]*", QueryParserUtil.escape((String)path));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.regexpQuery((String)"path", (String)regexPath));
        boolQueryBuilder.mustNot((QueryBuilder)new TermQueryBuilder("path", "/"));
        if (volumeId != null) {
            boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("volumeId", (Object)volumeId));
        }
        if (!showHiddenDirectories.booleanValue()) {
            boolQueryBuilder.mustNot((QueryBuilder)new PrefixQueryBuilder("name", "."));
        }
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getSearchRequest((QueryBuilder)boolQueryBuilder, fieldSort, sortDirection, from, size, Boolean.valueOf(true), indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public GetResponse getDirectoryByDocId(String documentId, LocalDate indexingDate) throws IOException {
        GetRequest getRequest = new GetRequest(ESFileQueryUtils.getIndexName((LocalDate)indexingDate)).id(documentId);
        return this.elasticsearchClient.get(getRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getSameDirectoryInformationAcrossTime(String path, Integer from, Integer size, Long volumeId, String fieldSort, SortOrder direction) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.FILE);
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("path", path));
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDirectory", true));
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("volumeId", (Object)volumeId));
        SearchRequest searchRequest = this.esFileQueryUtils.getSearchRequest((QueryBuilder)boolQueryBuilder, fieldSort, direction, from, size, Boolean.valueOf(true), "file-*");
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public void setDeletedFoldersAndFilesByPath(List<String> paths, Long volumeId, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.FILE);
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("isDeleted", false));
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder("volumeId", (Object)volumeId));
        BoolQueryBuilder folderPaths = new BoolQueryBuilder();
        for (String path : paths) {
            folderPaths.should((QueryBuilder)new TermQueryBuilder("path", path));
        }
        folderPaths.minimumShouldMatch(1);
        boolQueryBuilder.filter((QueryBuilder)folderPaths);
        UpdateByQueryRequest request = new UpdateByQueryRequest(new String[]{ESFileQueryUtils.getIndexName((LocalDate)indexingDate)});
        request.setQuery((QueryBuilder)boolQueryBuilder);
        request.setScript(new Script("ctx._source.isDeleted= 'true'"));
        request.setSlices(8);
        this.elasticsearchClient.updateByQuery(request, RequestOptions.DEFAULT);
    }

    public SearchResponse getDeletedFoldersByScanDateWithScroll(Integer size, Integer timeToLive, Date scanDate, Long volumeId, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQuery = this.esFileQueryUtils.getBasicBoolQueryBuilder(Boolean.valueOf(true), null);
        boolQuery.filter((QueryBuilder)new TermQueryBuilder("volumeId", (Object)volumeId));
        boolQuery.filter((QueryBuilder)new RangeQueryBuilder("indexingDate").lte((Object)scanDate.getTime()));
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getScrollSearchRequest((QueryBuilder)boolQuery, "name", SortOrder.ASC, timeToLive, size, indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getDirectoriesWithScroll(String path, Long volumeId, Integer size, LocalDate indexingDate, Integer timeToLive) throws IOException {
        BoolQueryBuilder boolQuery = this.esFileQueryUtils.getBasicBoolQueryBuilder(Boolean.valueOf(true), null);
        String regexPath = path.equals("/") ? "/[^/]*" : String.format("%s/[^/]*", QueryParserUtil.escape((String)path));
        boolQuery.filter((QueryBuilder)QueryBuilders.regexpQuery((String)"path", (String)regexPath));
        boolQuery.mustNot((QueryBuilder)new TermQueryBuilder("path", "/"));
        boolQuery.filter((QueryBuilder)new TermQueryBuilder("volumeId", (Object)volumeId));
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getScrollSearchRequest((QueryBuilder)boolQuery, "name", SortOrder.ASC, timeToLive, size, indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse getNextListWithScroll(String scrollId, Integer timeToLive) throws IOException {
        SearchScrollRequest searchScrollRequest = new SearchScrollRequest(scrollId).scroll(new TimeValue((long)timeToLive.intValue()));
        return this.elasticsearchClient.scroll(searchScrollRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse findPathByName(String path, LocalDate indexingDate, Integer size) throws IOException {
        BoolQueryBuilder boolQuery = this.esFileQueryUtils.getBasicBoolQueryBuilder(Boolean.valueOf(true), null);
        MatchQueryBuilder matchQueryBuilder = new MatchQueryBuilder("name", (Object)path);
        matchQueryBuilder.fuzziness((Object)Fuzziness.AUTO);
        matchQueryBuilder.prefixLength(3);
        boolQuery.filter((QueryBuilder)matchQueryBuilder);
        String indexName = ESFileQueryUtils.getIndexName((LocalDate)indexingDate);
        SearchRequest searchRequest = this.esFileQueryUtils.getSearchRequest((QueryBuilder)boolQuery, "size", SortOrder.DESC, Integer.valueOf(0), size, Boolean.valueOf(true), indexName);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }
}

