/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.repository.elasticsearch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.dataintell.visionapi.domain.DetailedProject;
import io.dataintell.visionapi.domain.IndexType;
import io.dataintell.visionapi.permission.Action;
import io.dataintell.visionapi.permission.ResourceFilterBuilder;
import io.dataintell.visionapi.permission.ResourceType;
import io.dataintell.visionapi.problem.BadRequestException;
import io.dataintell.visionapi.security.AuthenticationHelper;
import io.dataintell.visionapi.utils.HashUtils;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DetailedProjectRepository {
    private static final Logger log = LoggerFactory.getLogger(DetailedProjectRepository.class);
    private final RestHighLevelClient elasticsearchClient;
    private final ResourceFilterBuilder resourceFilterBuilder;

    public DetailedProjectRepository(RestHighLevelClient elasticsearchClient, ResourceFilterBuilder resourceFilterBuilder) {
        this.elasticsearchClient = elasticsearchClient;
        this.resourceFilterBuilder = resourceFilterBuilder;
    }

    public void indexDetailedProject(DetailedProject detailedProject, LocalDate indexingDate) throws IOException {
        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ").create();
        IndexRequest indexRequest = new IndexRequest(IndexType.PROJECT.label).id(this.getProjectId(detailedProject.getId(), indexingDate)).source(gson.toJson((Object)detailedProject), XContentType.JSON);
        this.elasticsearchClient.index(indexRequest, RequestOptions.DEFAULT);
        this.refreshIndex();
    }

    public SearchResponse findAll(Integer from, Integer size, String fieldSort, SortOrder sortDirection, LocalDate indexingDate, String filter) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.PROJECT);
        FieldSortBuilder sortBuilder = SortBuilders.fieldSort((String)fieldSort);
        sortBuilder.order(sortDirection);
        boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("indexingDate").gte((Object)indexingDate.atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        boolQueryBuilder.filter((QueryBuilder)new RangeQueryBuilder("indexingDate").lt((Object)indexingDate.plusDays(1L).atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"name", (String)("*" + filter + "*")));
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"description", (String)("*" + filter + "*")));
        boolQueryBuilder.minimumShouldMatch(1);
        SearchRequest searchRequest = new SearchRequest(new String[]{IndexType.PROJECT.label});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder).sort((SortBuilder)sortBuilder).from(from.intValue()).size(size.intValue());
        searchRequest.source(searchSourceBuilder);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public Optional<GetResponse> findOne(Long id, LocalDate indexingDate) {
        List roles = AuthenticationHelper.getAuthoritiesList();
        boolean isRequestDenied = roles.stream().flatMap(role -> role.getPrivileges().stream()).anyMatch(p -> ResourceType.PROJECT == p.getResourceType() && Action.DENY == p.getAction() && id.equals(p.getResourceId()));
        if (isRequestDenied) {
            log.info("Access denied for project with id [{}]", (Object)id);
            throw new BadRequestException(String.format("Access denied for project with id [%s]", id));
        }
        GetRequest getRequest = new GetRequest(IndexType.PROJECT.label).id(this.getProjectId(id, indexingDate));
        try {
            GetResponse response = this.elasticsearchClient.get(getRequest, RequestOptions.DEFAULT);
            if (response.isExists()) {
                return Optional.of(response);
            }
            return Optional.empty();
        }
        catch (IOException e) {
            log.error("Unable to reach Es cluster", (Throwable)e);
            return Optional.empty();
        }
    }

    public SearchResponse findProjectHistoryById(Long id, Integer size, LocalDate indexingDate) throws IOException {
        BoolQueryBuilder boolQueryBuilder = this.resourceFilterBuilder.preFilter(AuthenticationHelper.getAuthoritiesList(), IndexType.PROJECT).filter((QueryBuilder)new RangeQueryBuilder("indexingDate").lt((Object)indexingDate.plusDays(1L).atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli())).filter((QueryBuilder)new TermQueryBuilder("id", (Object)id));
        FieldSortBuilder sortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)"indexingDate").order(SortOrder.DESC);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).sort((SortBuilder)sortBuilder).size(size.intValue());
        SearchRequest searchRequest = new SearchRequest(new String[]{IndexType.PROJECT.label}).source(searchSourceBuilder);
        return this.elasticsearchClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    public void deleteOne(Long id, LocalDate indexingDate) throws IOException {
        DeleteRequest deleteRequest = new DeleteRequest(IndexType.PROJECT.label).id(this.getProjectId(id, indexingDate));
        this.elasticsearchClient.delete(deleteRequest, RequestOptions.DEFAULT);
        this.refreshIndex();
    }

    private String getProjectId(Long projectId, LocalDate indexingDate) {
        return HashUtils.createMD5Hash((String)(projectId.toString() + indexingDate.toString()));
    }

    private void refreshIndex() throws IOException {
        RefreshRequest request = new RefreshRequest(new String[]{"project"});
        this.elasticsearchClient.indices().refresh(request, RequestOptions.DEFAULT);
    }
}

