/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.problem;

import io.dataintell.visionapi.problem.ApiError;
import io.dataintell.visionapi.problem.ApiSubError;
import io.dataintell.visionapi.problem.ArchiwareP5Exception;
import io.dataintell.visionapi.problem.BadRequestException;
import io.dataintell.visionapi.problem.ElasticsearchIOException;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.problem.InvalidLicenseException;
import io.dataintell.visionapi.problem.InvalidPasswordException;
import io.dataintell.visionapi.problem.MappingException;
import io.dataintell.visionapi.problem.NotFoundException;
import io.dataintell.visionapi.problem.OperationForbiddenException;
import io.dataintell.visionapi.problem.S3BucketException;
import io.dataintell.visionapi.problem.SQLDeleteForeignKeyConstraintException;
import io.dataintell.visionapi.problem.ScheduleException;
import io.dataintell.visionapi.problem.UniqueConstraintException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class RestExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionHandler.class);

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        log.error(ex.getMessage());
        List errors = ex.getBindingResult().getFieldErrors().stream().map(x -> new ApiSubError(x.getObjectName(), x.getField(), x.getRejectedValue(), x.getDefaultMessage())).collect(Collectors.toList());
        ApiError apiError = new ApiError("Validation errors", (Throwable)ex);
        apiError.setSubErrors(errors);
        return new ResponseEntity((Object)apiError, status);
    }

    @ExceptionHandler(value={InvalidPasswordException.class})
    protected ResponseEntity<Object> handleInvalidPassword(InvalidPasswordException ex) {
        ArrayList<ApiSubError> errors = new ArrayList<ApiSubError>();
        errors.add(new ApiSubError("password", ex.getField(), (Object)ex.getRejectedValue(), ex.getMessage()));
        ApiError apiError = new ApiError("Validation errors", (Throwable)ex);
        apiError.setSubErrors(errors);
        return new ResponseEntity((Object)apiError, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={NotFoundException.class})
    protected ResponseEntity<Object> handleNotFoundException(NotFoundException ex) {
        ArrayList<ApiSubError> errors = new ArrayList<ApiSubError>();
        errors.add(new ApiSubError("url", ex.getField(), (Object)ex.getRejectedValue(), ex.getMessage()));
        ApiError apiError = new ApiError("Validation errors", (Throwable)ex);
        apiError.setSubErrors(errors);
        return new ResponseEntity((Object)apiError, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={ArchiwareP5Exception.class})
    protected ResponseEntity<Object> handleArchiwareP5Exception(ArchiwareP5Exception ex) {
        ArrayList<ApiSubError> errors = new ArrayList<ApiSubError>();
        errors.add(new ApiSubError("ArchiwareP5", ex.getField(), (Object)ex.getRejectedValue(), ex.getMessage()));
        ApiError apiError = new ApiError("Validation errors", (Throwable)ex);
        apiError.setSubErrors(errors);
        return new ResponseEntity((Object)apiError, HttpStatus.BAD_REQUEST);
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        log.error(ex.getMessage());
        return new ResponseEntity((Object)new ApiError("Malformed JSON request", (Throwable)ex), status);
    }

    @ExceptionHandler(value={EntityNotFoundException.class})
    protected ResponseEntity<ApiError> handleEntityNotFound(EntityNotFoundException ex) {
        log.error(ex.getMessage());
        ApiError apiError = new ApiError();
        apiError.setMessage(ex.getMessage());
        return new ResponseEntity((Object)apiError, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={UniqueConstraintException.class})
    protected ResponseEntity<ApiError> handleUniqueConstraint(UniqueConstraintException ex) {
        log.error(ex.getMessage());
        ApiError apiError = new ApiError();
        apiError.setMessage(ex.getMessage());
        return new ResponseEntity((Object)apiError, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={BadRequestException.class})
    protected ResponseEntity<ApiError> handleBadRequest(BadRequestException ex) {
        log.error(ex.getMessage());
        ApiError apiError = new ApiError();
        apiError.setMessage(ex.getMessage());
        return new ResponseEntity((Object)apiError, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={SQLDeleteForeignKeyConstraintException.class})
    protected ResponseEntity<ApiError> handleSQLDeleteException(SQLDeleteForeignKeyConstraintException ex) {
        ApiError apiError = new ApiError();
        apiError.setMessage(ex.getMessage());
        return new ResponseEntity((Object)apiError, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={ScheduleException.class})
    protected ResponseEntity<ApiError> handleScheduleException(ScheduleException ex) {
        log.error(ex.getMessage());
        ApiError apiError = new ApiError();
        apiError.setMessage(ex.getMessage());
        return new ResponseEntity((Object)apiError, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ElasticsearchIOException.class})
    protected ResponseEntity<ApiError> handleElasticSearchIOException(ElasticsearchIOException ex) {
        log.error(ex.getMessage());
        ApiError apiError = new ApiError();
        apiError.setMessage(ex.getMessage());
        return new ResponseEntity((Object)apiError, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={S3BucketException.class})
    protected ResponseEntity<ApiError> handleS3BucketException(S3BucketException ex) {
        log.error(ex.getMessage());
        ApiError apiError = new ApiError();
        apiError.setMessage(ex.getMessage());
        return new ResponseEntity((Object)apiError, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InvalidLicenseException.class})
    protected ResponseEntity<ApiError> handleInvalidLicense(InvalidLicenseException ex) {
        log.error(ex.getMessage());
        ApiError apiError = new ApiError();
        apiError.setMessage(ex.getMessage());
        return new ResponseEntity((Object)apiError, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={OperationForbiddenException.class})
    protected ResponseEntity<ApiError> handleOperationForbidden(OperationForbiddenException ex) {
        log.error(ex.getMessage());
        ApiError apiError = new ApiError();
        apiError.setMessage(ex.getMessage());
        return new ResponseEntity((Object)apiError, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={MappingException.class})
    protected ResponseEntity<ApiError> handleMappingException(MappingException ex) {
        log.error(ex.getMessage());
        ApiError apiError = new ApiError();
        apiError.setMessage(ex.getMessage());
        return new ResponseEntity((Object)apiError, HttpStatus.BAD_REQUEST);
    }
}

