/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.permission;

import io.dataintell.visionapi.domain.IndexType;
import io.dataintell.visionapi.entity.PrivilegeEntity;
import io.dataintell.visionapi.permission.Action;
import io.dataintell.visionapi.security.Role;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.springframework.stereotype.Component;

@Component
public class ResourceFilterBuilder {
    public BoolQueryBuilder preFilter(List<Role> roles, IndexType resource) {
        if (roles.stream().anyMatch(role -> role.getAuthority().equals("ROLE_ADMIN"))) {
            return new BoolQueryBuilder();
        }
        String filterResourced = resource.equals((Object)IndexType.PROJECT) ? IndexType.PROJECT.name() : IndexType.VOLUME.name();
        List privileges = roles.stream().flatMap(role -> role.getPrivileges().stream()).filter(p -> filterResourced.equals(p.getResourceType().name())).collect(Collectors.toList());
        List allowedIds = privileges.stream().filter(p -> p.getAction() == Action.ALLOW).map(PrivilegeEntity::getResourceId).collect(Collectors.toList());
        List deniedIds = privileges.stream().filter(p -> p.getAction() == Action.DENY).map(PrivilegeEntity::getResourceId).collect(Collectors.toList());
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        if (deniedIds.contains(-1L)) {
            return boolQueryBuilder.must((QueryBuilder)new TermQueryBuilder(this.getFieldName(resource), -1L));
        }
        if (!allowedIds.isEmpty()) {
            boolQueryBuilder.filter((QueryBuilder)new TermsQueryBuilder(this.getFieldName(resource), allowedIds));
        }
        if (!deniedIds.isEmpty()) {
            boolQueryBuilder.mustNot((QueryBuilder)new TermsQueryBuilder(this.getFieldName(resource), deniedIds));
        }
        return boolQueryBuilder;
    }

    private String getFieldName(IndexType resource) {
        if (resource == IndexType.FILE) {
            return "volumeId";
        }
        return "id";
    }
}

