/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.mapper;

import io.dataintell.visionapi.domain.Volume;
import io.dataintell.visionapi.mapper.DTOMapper;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.elasticsearch.search.aggregations.metrics.Max;
import org.elasticsearch.search.aggregations.metrics.Min;
import org.springframework.stereotype.Component;

@Component
public class VolumeMapper
extends DTOMapper<Volume> {
    public Volume getGsonFromJson(SearchHit searchHit) {
        return (Volume)this.gson.fromJson(searchHit.getSourceAsString(), Volume.class);
    }

    public List<Volume> convertToDto(SearchResponse response) {
        SearchHit[] searchHits = response.getHits().getHits();
        return Arrays.stream(searchHits).map(arg_0 -> this.getGsonFromJson(arg_0)).collect(Collectors.toList());
    }

    public HashMap<Long, Long> getVolumeAndIndexingDateAggregation(SearchResponse searchResponse) {
        Aggregations aggregations = searchResponse.getAggregations();
        ParsedLongTerms volumeIds = (ParsedLongTerms)aggregations.get("volumeId");
        List volumeIdBuckets = volumeIds.getBuckets();
        HashMap<Long, Long> latestVersions = new HashMap<Long, Long>();
        volumeIdBuckets.forEach(bucket -> {
            Max mostRecent = (Max)bucket.getAggregations().get("mostRecent");
            latestVersions.put((Long)bucket.getKeyAsNumber(), (long)mostRecent.getValue());
        });
        return latestVersions;
    }

    public HashMap<LocalDate, List<Long>> getVolumeIDsGroupByIndexingDateAggregation(SearchResponse searchResponse) {
        Aggregations aggregations = searchResponse.getAggregations();
        ParsedLongTerms volumeIds = (ParsedLongTerms)aggregations.get("volumeId");
        HashMap<LocalDate, List<Long>> volumeIdsGroupByDate = new HashMap<LocalDate, List<Long>>();
        List volumeIdBuckets = volumeIds.getBuckets();
        volumeIdBuckets.forEach(bucket -> {
            Min mostRecent = (Min)bucket.getAggregations().get("closestDate");
            Instant instant = Instant.ofEpochMilli((long)mostRecent.getValue());
            LocalDate localDate = LocalDate.ofInstant(instant, ZoneId.systemDefault());
            if (volumeIdsGroupByDate.containsKey(localDate)) {
                ((List)volumeIdsGroupByDate.get(localDate)).add(Long.valueOf((Long)bucket.getKeyAsNumber()));
            } else {
                ArrayList<Long> newList = new ArrayList<Long>();
                newList.add((Long)bucket.getKeyAsNumber());
                volumeIdsGroupByDate.put(localDate, newList);
            }
        });
        return volumeIdsGroupByDate;
    }
}

