/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.mapper;

import io.dataintell.visionapi.domain.Statistic;
import io.dataintell.visionapi.utils.DateUtils;
import java.time.LocalDate;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.metrics.Max;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.springframework.stereotype.Component;

@Component
public class StatisticMapper {
    public Statistic convertToDto(SearchResponse searchResponse, String name, LocalDate indexingDate) {
        Statistic statistic = new Statistic();
        Aggregations aggregations = searchResponse.getAggregations();
        Max lastAccess = (Max)aggregations.get("lastAccess");
        if (lastAccess != null) {
            statistic.setLastAccess(DateUtils.getLocalDateTimeFromDouble((double)lastAccess.getValue()));
        }
        statistic.setNumberOfFiles(Long.valueOf(searchResponse.getHits().getTotalHits().value));
        Sum agg = (Sum)aggregations.get("size");
        Long value = (long)agg.getValue();
        statistic.setSize(value);
        statistic.setName(name);
        statistic.setIndexingDate(indexingDate);
        return statistic;
    }
}

