/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.mapper;

import io.dataintell.visionapi.domain.IdentificationHashPaginatedResponse;
import io.dataintell.visionapi.domain.IdentificationHashResponse;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.springframework.stereotype.Component;

@Component
public class IdentificationHashPaginatedResponseMapper {
    public IdentificationHashPaginatedResponse convertToDto(SearchResponse searchResponse) {
        Aggregations aggregations = searchResponse.getAggregations();
        CompositeAggregation compositeAggregation = (CompositeAggregation)aggregations.get("my_buckets");
        if (compositeAggregation.getBuckets().size() == 0) {
            return null;
        }
        IdentificationHashPaginatedResponse identificationHashPaginatedResponse = new IdentificationHashPaginatedResponse();
        identificationHashPaginatedResponse.setAfterKey((String)compositeAggregation.afterKey().get("identificationHashCount"));
        List identificationHashResponses = compositeAggregation.getBuckets().parallelStream().map(b -> {
            IdentificationHashResponse identificationHashResponse = new IdentificationHashResponse();
            identificationHashResponse.setIdentificationHash(b.getKey().get("identificationHashCount").toString());
            identificationHashResponse.setCount(Long.valueOf(b.getDocCount()));
            ParsedLongTerms dupeAggregation = (ParsedLongTerms)b.getAggregations().get("dupe");
            identificationHashResponse.setFalseCount(Long.valueOf(0L));
            identificationHashResponse.setTrueCount(Long.valueOf(0L));
            dupeAggregation.getBuckets().forEach(dupeBucket -> {
                if (dupeBucket.getKeyAsNumber().equals(1L)) {
                    identificationHashResponse.setTrueCount(Long.valueOf(dupeBucket.getDocCount()));
                } else if (dupeBucket.getKeyAsNumber().equals(0L)) {
                    identificationHashResponse.setFalseCount(Long.valueOf(dupeBucket.getDocCount()));
                }
            });
            return identificationHashResponse;
        }).collect(Collectors.toList());
        identificationHashPaginatedResponse.setIdentificationHashResponse(identificationHashResponses);
        return identificationHashPaginatedResponse;
    }
}

