/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.mapper;

import io.dataintell.visionapi.domain.FieldCountSize;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.springframework.stereotype.Component;

@Component
public class FieldCountSizeMapper {
    public List<FieldCountSize> convertToDTO(SearchResponse response) {
        Aggregations aggregations = response.getAggregations();
        ArrayList<FieldCountSize> fieldCountSizeList = new ArrayList<FieldCountSize>();
        Terms fieldAgg = (Terms)aggregations.get("fieldName");
        for (Terms.Bucket entry : fieldAgg.getBuckets()) {
            FieldCountSize fieldHistogram = new FieldCountSize();
            String field = entry.getKey().toString();
            fieldHistogram.setField(field);
            fieldHistogram.setCount(Long.valueOf(entry.getDocCount()));
            Sum sumAgg = (Sum)entry.getAggregations().get("size");
            fieldHistogram.setSize(Long.valueOf((long)sumAgg.getValue()));
            fieldCountSizeList.add(fieldHistogram);
        }
        return fieldCountSizeList;
    }
}

