/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.mapper;

import io.dataintell.visionapi.domain.DateHistogram;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.springframework.stereotype.Component;

@Component
public class DateHistogramMapper {
    public List<DateHistogram> convertToDTO(SearchResponse response) {
        Aggregations aggregations = response.getAggregations();
        ArrayList<DateHistogram> dateHistograms = new ArrayList<DateHistogram>();
        Histogram dateHistogramAgg = (Histogram)aggregations.get("dateHistogram");
        for (Histogram.Bucket entry : dateHistogramAgg.getBuckets()) {
            DateHistogram dateHistogram = new DateHistogram();
            ZonedDateTime date = (ZonedDateTime)entry.getKey();
            dateHistogram.setDate(LocalDate.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth()));
            dateHistogram.setCount(Long.valueOf(entry.getDocCount()));
            Sum sumAgg = (Sum)entry.getAggregations().get("size");
            dateHistogram.setSize(Long.valueOf((long)sumAgg.getValue()));
            dateHistograms.add(dateHistogram);
        }
        return dateHistograms;
    }
}

