/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.mapper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.domain.ScrollResult;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;

public abstract class DTOMapper<T> {
    protected Gson gson;

    public DTOMapper() {
        this.gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").create();
    }

    public DTOMapper(String dateFormat) {
        this.gson = new GsonBuilder().setDateFormat(dateFormat).create();
    }

    public abstract T getGsonFromJson(SearchHit var1);

    public abstract List<T> convertToDto(SearchResponse var1);

    @Deprecated
    public PaginatedResult<T> getPaginatedResult(Integer page, String sortField, String direction, SearchResponse searchResponse) {
        return PaginatedResult.builder().page(page).sort(sortField).direction(direction).size(Integer.valueOf(searchResponse.getHits().getHits().length)).total(Long.valueOf(searchResponse.getHits().getTotalHits().value)).scrollId(null).elements(this.convertToDto(searchResponse)).build();
    }

    public PaginatedResult<T> getPaginatedResultWithSize(int page, int size, String sortField, String direction, SearchResponse searchResponse) {
        return PaginatedResult.builder().page(Integer.valueOf(page)).sort(sortField).direction(direction).size(Integer.valueOf(size)).total(Long.valueOf(searchResponse.getHits().getTotalHits().value)).scrollId(null).elements(this.convertToDto(searchResponse)).build();
    }

    @Deprecated
    public PaginatedResult<T> getPaginatedResultWithScrollId(SearchResponse searchResponse) {
        return PaginatedResult.builder().page(null).sort(null).direction(null).size(Integer.valueOf(searchResponse.getHits().getHits().length)).total(Long.valueOf(searchResponse.getHits().getTotalHits().value)).scrollId(searchResponse.getScrollId()).elements(this.convertToDto(searchResponse)).build();
    }

    public ScrollResult<T> getScrollResult(SearchResponse searchResponse) {
        return ScrollResult.builder().total(Long.valueOf(searchResponse.getHits().getTotalHits().value)).scrollId(searchResponse.getScrollId()).elements(this.convertToDto(searchResponse)).build();
    }
}

