/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.mapper;

import io.dataintell.visionapi.domain.ArchiwareP5Credential;
import io.dataintell.visionapi.domain.ArchiwareP5Index;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.entity.ArchiwareP5CredentialEntity;
import io.dataintell.visionapi.entity.ArchiwareP5IndexEntity;
import io.dataintell.visionapi.security.PasswordEncrypt;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
public class ArchiwareMapper {
    public ArchiwareP5Credential toDTO(ArchiwareP5CredentialEntity archiwareP5CredentialEntity) {
        return ArchiwareP5Credential.builder().id(archiwareP5CredentialEntity.getId()).name(archiwareP5CredentialEntity.getName()).url(archiwareP5CredentialEntity.getUrl()).username(archiwareP5CredentialEntity.getUsername()).build();
    }

    public ArchiwareP5CredentialEntity toEntity(ArchiwareP5Credential archiwareP5Credential) {
        return ArchiwareP5CredentialEntity.builder().name(archiwareP5Credential.getName()).url(archiwareP5Credential.getUrl()).username(archiwareP5Credential.getUsername()).password(archiwareP5Credential.getPassword()).build();
    }

    public ArchiwareP5Index toDTO(ArchiwareP5IndexEntity entity) {
        return ArchiwareP5Index.builder().id(entity.getId()).indexId(entity.getIndexId()).path(entity.getPath()).name(entity.getVolumeSetting().getName()).volumeSettingId(entity.getVolumeSetting().getId()).storagePrice(entity.getVolumeSetting().getStoragePrice()).serverId(entity.getVolumeSetting().getServer().getId()).archiwareP5Credential(this.toDTO(entity.getArchiwareP5CredentialEntity())).build();
    }

    public ArchiwareP5Credential toDTOWithPassword(ArchiwareP5CredentialEntity entity) {
        ArchiwareP5Credential archiwareP5Credential = this.toDTO(entity);
        archiwareP5Credential.setPassword(PasswordEncrypt.decrypt((String)entity.getPassword()));
        return archiwareP5Credential;
    }

    public ArchiwareP5Index toDTOWithPassword(ArchiwareP5IndexEntity entity) {
        ArchiwareP5Index archiwareP5Index = this.toDTO(entity);
        archiwareP5Index.getArchiwareP5Credential().setPassword(PasswordEncrypt.decrypt((String)entity.getArchiwareP5CredentialEntity().getPassword()));
        return archiwareP5Index;
    }

    public ArchiwareP5IndexEntity toEntity(ArchiwareP5Index archiwareP5Index) {
        return ArchiwareP5IndexEntity.builder().indexId(archiwareP5Index.getIndexId()).path(archiwareP5Index.getPath()).build();
    }

    public PaginatedResult<ArchiwareP5Credential> toPaginatedResults(Page<ArchiwareP5CredentialEntity> archiwareP5CredentialEntities, String sortParameter, Sort.Direction direction, Integer size) {
        PaginatedResult archiwareP5CredentialPaginatedResult = new PaginatedResult();
        archiwareP5CredentialPaginatedResult.setDirection(direction.name().toLowerCase());
        archiwareP5CredentialPaginatedResult.setSort(sortParameter);
        archiwareP5CredentialPaginatedResult.setTotal(Long.valueOf(archiwareP5CredentialEntities.getTotalElements()));
        archiwareP5CredentialPaginatedResult.setSize(size);
        archiwareP5CredentialPaginatedResult.setPage(Integer.valueOf(archiwareP5CredentialEntities.getNumber() + 1));
        archiwareP5CredentialPaginatedResult.setElements(archiwareP5CredentialEntities.getContent().stream().map(arg_0 -> this.toDTO(arg_0)).collect(Collectors.toList()));
        return archiwareP5CredentialPaginatedResult;
    }
}

