/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.license;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dataintell.visionapi.license.LicenseManager;
import io.dataintell.visionapi.problem.ApiError;
import io.dataintell.visionapi.problem.InvalidLicenseException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class LicenseValidationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(LicenseValidationFilter.class);
    private final LicenseManager licenseManager;
    private static final List<String> WHITE_LISTED_ROUTES = Arrays.asList("/auth/signin", "/license", "/actuator");

    public LicenseValidationFilter(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.licenseManager.getLicense().isValid() || this.isRouteWhitelisted(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            log.error("Invalid License");
            ApiError apiError = new ApiError(HttpStatus.FORBIDDEN.getReasonPhrase(), (Throwable)new InvalidLicenseException("Invalid License"));
            response.setContentType("application/json");
            response.setStatus(HttpStatus.FORBIDDEN.value());
            ObjectMapper mapper = new ObjectMapper();
            response.getWriter().write(mapper.writeValueAsString((Object)apiError));
        }
    }

    private boolean isRouteWhitelisted(HttpServletRequest request) {
        return WHITE_LISTED_ROUTES.stream().anyMatch(route -> request.getRequestURI().contains((CharSequence)route));
    }
}

