/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.license;

import com.javax0.license3j.licensor.License;
import io.dataintell.visionapi.domain.Configuration;
import io.dataintell.visionapi.license.DataIntellLicense;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.problem.InvalidLicenseException;
import io.dataintell.visionapi.schedule.ScheduleService;
import io.dataintell.visionapi.service.ConfigurationService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.bouncycastle.openpgp.PGPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.stereotype.Service;

@Service
public class LicenseManager
implements InfoContributor {
    private static final Logger log = LoggerFactory.getLogger(LicenseManager.class);
    private static final String PUBRING_GPG = "pubring.gpg";
    private static final byte[] DIGEST = new byte[]{51, -122, -117, -42, 43, -109, 115, 84, -23, 11, -120, -54, 95, 112, 64, -48, -123, 88, 45, 14, 59, -65, 92, -27, 50, -102, -125, -86, -4, 75, -115, -65, 33, 47, -96, -101, -77, -19, -3, -95, -39, -37, 93, -128, -116, -120, 7, 114, -77, -97, 94, 62, 122, 16, -67, -100, 113, -28, -5, -44, 94, 2, 48, -128};
    public static final String APP_LICENSE = "app.license";
    private final ConfigurationService configurationService;
    private final ScheduleService scheduleService;
    private DataIntellLicense license = DataIntellLicense.getInvalid();

    public LicenseManager(ConfigurationService configurationService, ScheduleService scheduleService) throws IOException, PGPException {
        this.configurationService = configurationService;
        this.scheduleService = scheduleService;
        this.loadLicense();
    }

    public DataIntellLicense getLicense() {
        return this.license;
    }

    private void loadLicense() throws IOException, PGPException {
        License lic = new License();
        lic.loadKeyRingFromResource(PUBRING_GPG, DIGEST);
        try {
            Configuration configuration = this.configurationService.getConfigurationByName(APP_LICENSE);
            lic.setLicenseEncoded(configuration.getValue());
            this.license = DataIntellLicense.of((License)lic);
        }
        catch (EntityNotFoundException e) {
            log.warn("Unable to find license in database, looking for license on disk");
            try {
                ApplicationHome home = new ApplicationHome(this.getClass());
                File file = new File(String.format("%s/ordigrapheLicense", home.getDir().getAbsolutePath()));
                lic.setLicenseEncodedFromFile(file.getPath(), StandardCharsets.UTF_8.name());
                this.license = DataIntellLicense.of((License)lic);
            }
            catch (IOException | PGPException exception) {
                log.error("Unable to load license from disk, booting with INVALID license");
            }
        }
    }

    public DataIntellLicense updateLicense(String license) {
        try {
            License lic = new License();
            lic.loadKeyRingFromResource(PUBRING_GPG, DIGEST);
            lic.setLicenseEncoded(license);
            DataIntellLicense newLicense = DataIntellLicense.of((License)lic);
            if (newLicense.isValid()) {
                this.configurationService.upsert(new Configuration(null, APP_LICENSE, APP_LICENSE, license));
                this.license = newLicense;
                this.scheduleService.resumeAll();
                return this.license;
            }
            throw new InvalidLicenseException("This license is invalid, operation aborted");
        }
        catch (IOException | PGPException e) {
            throw new InvalidLicenseException("This license is invalid, operation aborted");
        }
    }

    public void contribute(Info.Builder builder) {
        builder.withDetail("license", Map.of("expirationDate", this.license.getExpirationDate(), "isValid", this.license.isValid()));
    }
}

