/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.license;

import io.dataintell.visionapi.license.DataIntellLicense;
import io.dataintell.visionapi.license.LicenseManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="License", description="Update your license")
public class LicenseController {
    private final LicenseManager licenseManager;

    public LicenseController(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    @PutMapping(value={"v1/license"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Update License")
    public DataIntellLicense update(@RequestBody String license) {
        return this.licenseManager.updateLicense(license);
    }
}

