/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.license;

import io.dataintell.visionapi.license.HasBundles;
import io.dataintell.visionapi.license.LicenseManager;
import io.dataintell.visionapi.problem.OperationForbiddenException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class HasBundlesAspect {
    private final LicenseManager licenseManager;

    public HasBundlesAspect(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    @Before(value="@annotation(HasBundles)")
    public void hasBundle(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        HasBundles hasBundles = method.getAnnotation(HasBundles.class);
        CharSequence[] allowedBundles = hasBundles.value();
        List licenseBundles = this.licenseManager.getLicense().getBundles();
        if (Arrays.stream(allowedBundles).anyMatch(licenseBundles::contains)) {
            return;
        }
        String joinedBundles = String.join((CharSequence)", ", allowedBundles);
        throw new OperationForbiddenException(String.format("You are not authorized to access this resource, you need to have one of these bundles [%s] in your license", joinedBundles));
    }
}

