/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.license;

import com.javax0.license3j.licensor.License;
import io.dataintell.visionapi.license.DataIntellLicense;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataIntellLicense {
    public static final String MAC_ADDRESS = "MacAddress";
    public static final String NAME = "Name";
    public static final String TYPE = "Type";
    public static final String EXPIRATION_DATE = "ExpirationDate";
    public static final String INVALID = "INVALID";
    public static final String BUNDLES = "Bundles";
    private final String macAddress;
    private final String name;
    private final String type;
    private final LocalDate expirationDate;
    private final List<String> bundles;

    public static DataIntellLicense of(License lic) {
        String macAddress = lic.getFeature("MacAddress");
        String name = lic.getFeature("Name");
        String type = lic.getFeature("Type");
        String expirationDate = lic.getFeature("ExpirationDate");
        List bundles = Arrays.stream(lic.getFeature("Bundles").split(",")).map(String::trim).collect(Collectors.toList());
        if (macAddress == null || name == null || type == null || expirationDate == null) {
            return DataIntellLicense.getInvalid();
        }
        return DataIntellLicense.builder().macAddress(macAddress).name(name).type(type).expirationDate(LocalDate.parse(expirationDate)).bundles(bundles).build();
    }

    public static DataIntellLicense getInvalid() {
        return DataIntellLicense.builder().macAddress("INVALID").name("INVALID").type("INVALID").expirationDate(LocalDate.of(1989, 12, 19)).build();
    }

    public boolean isValid() {
        return this.isValidMacAddress() && this.isNotExpired() && this.isValidName();
    }

    private boolean isValidMacAddress() {
        if (this.type.equals("CLOUD")) {
            return true;
        }
        try {
            return this.getMacAddresses().stream().anyMatch(m -> m.equalsIgnoreCase(this.macAddress));
        }
        catch (SocketException e) {
            return false;
        }
    }

    private boolean isNotExpired() {
        return !LocalDate.now().isAfter(this.expirationDate);
    }

    private boolean isValidName() {
        return "DataIntell".equals(this.name);
    }

    private List<String> getMacAddresses() throws SocketException {
        ArrayList<String> macAddresses = new ArrayList<String>();
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface iface = en.nextElement();
            List<InterfaceAddress> addrs = iface.getInterfaceAddresses();
            for (InterfaceAddress addr : addrs) {
                InetAddress ip = addr.getAddress();
                NetworkInterface network = NetworkInterface.getByInetAddress(ip);
                byte[] mac = network.getHardwareAddress();
                if (mac == null) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? ":" : ""));
                    macAddresses.add(sb.toString());
                }
            }
        }
        return macAddresses;
    }

    DataIntellLicense(String macAddress, String name, String type, LocalDate expirationDate, List<String> bundles) {
        this.macAddress = macAddress;
        this.name = name;
        this.type = type;
        this.expirationDate = expirationDate;
        this.bundles = bundles;
    }

    public static DataIntellLicenseBuilder builder() {
        return new DataIntellLicenseBuilder();
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public LocalDate getExpirationDate() {
        return this.expirationDate;
    }

    public List<String> getBundles() {
        return this.bundles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataIntellLicense)) {
            return false;
        }
        DataIntellLicense other = (DataIntellLicense)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$macAddress = this.getMacAddress();
        String other$macAddress = other.getMacAddress();
        if (this$macAddress == null ? other$macAddress != null : !this$macAddress.equals(other$macAddress)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        LocalDate this$expirationDate = this.getExpirationDate();
        LocalDate other$expirationDate = other.getExpirationDate();
        if (this$expirationDate == null ? other$expirationDate != null : !((Object)this$expirationDate).equals(other$expirationDate)) {
            return false;
        }
        List this$bundles = this.getBundles();
        List other$bundles = other.getBundles();
        return !(this$bundles == null ? other$bundles != null : !((Object)this$bundles).equals(other$bundles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataIntellLicense;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $macAddress = this.getMacAddress();
        result = result * 59 + ($macAddress == null ? 43 : $macAddress.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        LocalDate $expirationDate = this.getExpirationDate();
        result = result * 59 + ($expirationDate == null ? 43 : ((Object)$expirationDate).hashCode());
        List $bundles = this.getBundles();
        result = result * 59 + ($bundles == null ? 43 : ((Object)$bundles).hashCode());
        return result;
    }

    public String toString() {
        return "DataIntellLicense(macAddress=" + this.getMacAddress() + ", name=" + this.getName() + ", type=" + this.getType() + ", expirationDate=" + this.getExpirationDate() + ", bundles=" + this.getBundles() + ")";
    }
}

