/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.legacyscanner;

import io.dataintell.visionapi.domain.Volume;
import io.dataintell.visionapi.entity.VolumeSetting;
import io.dataintell.visionapi.utils.HashUtils;
import java.io.File;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class VolumeBuilder {
    @Value(value="${demomode:false}")
    private Boolean demoMode;
    private static final Logger logger = LoggerFactory.getLogger(VolumeBuilder.class);

    public Volume createVolume(VolumeSetting volumeSetting, Date scanDate, LocalDate indexingDate) {
        Volume volume = new Volume();
        volume.setId(volumeSetting.getId());
        volume.setName(volumeSetting.getName());
        volume.setPath(volumeSetting.getPath());
        String documentId = HashUtils.createMD5Hash((String)(String.valueOf(scanDate.getTime()) + volumeSetting.getId()));
        volume.setDocumentId(documentId);
        if (this.demoMode.booleanValue()) {
            this.setSizeForDemo(volumeSetting.getPath(), volume);
        } else {
            this.setSize(volumeSetting.getPath(), volume);
        }
        volume.setIndexingDate(this.getIndexingDate(scanDate, indexingDate));
        volume.setType(volumeSetting.getType());
        return volume;
    }

    private Date getIndexingDate(Date scanDate, LocalDate indexingDate) {
        Date newIndexingDate = scanDate;
        LocalDate scanDateFormatted = scanDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (!scanDateFormatted.equals(indexingDate)) {
            newIndexingDate = Date.from(indexingDate.atTime(LocalTime.MAX).atZone(ZoneId.systemDefault()).toInstant());
        }
        return newIndexingDate;
    }

    private void setSize(String path, Volume volume) {
        logger.info(String.format("About to get size for volume [%s]", volume.getName()));
        File directory = new File(path);
        volume.setFree(Long.valueOf(directory.getFreeSpace()));
        volume.setTotal(Long.valueOf(directory.getTotalSpace()));
        volume.setUsed(Long.valueOf(directory.getTotalSpace() - directory.getFreeSpace()));
    }

    private void setSizeForDemo(String path, Volume volume) {
        logger.info(String.format("About to get size for volume for demo unit [%s]", volume.getName()));
        File directory = new File(path);
        volume.setFree(Long.valueOf(directory.getFreeSpace() * 1000L));
        volume.setTotal(Long.valueOf(directory.getTotalSpace() * 1000L));
        volume.setUsed(Long.valueOf((directory.getTotalSpace() - directory.getFreeSpace()) * 1000L));
    }
}

