/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.legacyscanner;

import io.dataintell.visionapi.domain.File;
import io.dataintell.visionapi.file.IngestFileProcessor;
import io.dataintell.visionapi.utils.HashUtils;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanQueue {
    private final IngestFileProcessor ingestFileProcessor;
    private final ConcurrentHashMap<String, File> directoryQueue = new ConcurrentHashMap();
    private static final Logger logger = LoggerFactory.getLogger(ScanQueue.class);

    public ScanQueue(IngestFileProcessor ingestFileProcessor) {
        this.ingestFileProcessor = ingestFileProcessor;
    }

    public void addFileToQueue(File file) {
        this.ingestFileProcessor.processFile(file);
    }

    public void initiateDirectory(File directory) {
        this.directoryQueue.putIfAbsent(directory.getPath(), directory);
    }

    public void updateDirectory(String path, Long size, Date lastAccessDate, Date lastModifiedDate, Long numberOfFiles, Long numberOfFolders) {
        File directory = (File)this.directoryQueue.get(path);
        if (directory == null) {
            logger.error("Unable to update directory with path [{}] because it's no longer in the queue", (Object)path);
            return;
        }
        directory.setSize(Long.valueOf(directory.getSize() + size));
        directory.setNumberOfFiles(Long.valueOf(directory.getNumberOfFiles() + numberOfFiles));
        directory.setNumberOfFolders(Long.valueOf(directory.getNumberOfFolders() + numberOfFolders));
        if (directory.getLastAccess().before(lastAccessDate)) {
            directory.setLastAccess(lastAccessDate);
        }
        if (directory.getLastModified().before(lastModifiedDate)) {
            directory.setLastModified(lastModifiedDate);
        }
    }

    public void updateDirectoryWithChild(String childPath, String path) {
        if (childPath.equals("/")) {
            return;
        }
        File directory = (File)this.directoryQueue.get(childPath);
        if (directory == null) {
            logger.error("Unable to update directory parent [{}] with child path [{}] because it's no longer in the queue", (Object)path, (Object)childPath);
            return;
        }
        this.updateDirectory(path, directory.getSize(), directory.getLastAccess(), directory.getLastModified(), directory.getNumberOfFiles(), Long.valueOf(directory.getNumberOfFolders() + 1L));
    }

    public void addDirectoryToQueue(String path) {
        File directory = (File)this.directoryQueue.get(path);
        if (directory == null) {
            logger.error("Unable to save directory with path [{}] because it's no longer in the queue", (Object)path);
            return;
        }
        directory.setIdentificationHash(HashUtils.getMD5Hash((File)directory));
        this.addFileToQueue(directory);
        this.directoryQueue.remove(path);
    }

    public void emptyDirectoryQueue() {
        this.directoryQueue.values().forEach(directory -> {
            directory.setIdentificationHash(HashUtils.getMD5Hash((File)directory));
            this.addFileToQueue(directory);
        });
    }
}

