/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.legacyscanner;

import io.dataintell.visionapi.legacyscanner.FileBuilder;
import io.dataintell.visionapi.legacyscanner.FolderToScan;
import io.dataintell.visionapi.legacyscanner.FullScanVisitor;
import io.dataintell.visionapi.legacyscanner.ScanQueue;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class InitialScanVisitor
extends FullScanVisitor {
    private final List<FolderToScan> paths = new ArrayList();
    private final String mountPath;
    private final Integer multithreadDepth;

    public InitialScanVisitor(FileBuilder fileBuilder, ScanQueue scanQueue, String volumeName, Long volumeId, String mountPath, Date lastScan, Integer multithreadDepth) {
        super(fileBuilder, scanQueue, volumeName, volumeId, mountPath, "/", lastScan);
        this.mountPath = mountPath;
        this.multithreadDepth = multithreadDepth;
    }

    public List<FolderToScan> getPaths() {
        return this.paths;
    }

    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        if (dir.toString().equals(super.getFullScanForPath())) {
            super.setFullScanForPath(null);
        }
        if (this.doesPathHasDepth(this.multithreadDepth.intValue(), dir)) {
            this.paths.add(new FolderToScan(dir, super.getFullScanForPath() != null));
        }
        return FileVisitResult.CONTINUE;
    }

    private boolean doesPathHasDepth(int depth, Path dir) {
        if (depth == 1 && dir.toString().equals(this.mountPath)) {
            return true;
        }
        if (depth > 1 && dir.getParent() != null) {
            return this.doesPathHasDepth(depth - 1, dir.getParent());
        }
        return false;
    }

    public FileVisitResult visitFile(Path path, BasicFileAttributes attr) {
        return FileVisitResult.CONTINUE;
    }
}

