/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.legacyscanner;

import io.dataintell.visionapi.domain.File;
import io.dataintell.visionapi.utils.FormatUtils;
import io.dataintell.visionapi.utils.HashUtils;
import io.dataintell.visionapi.utils.StringUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Component;

@Component
public class FileBuilder {
    public File createFile(Path path, BasicFileAttributes attr, String mountPath, String volumeName, Long volumeId, Date lastScan) throws IOException {
        File file = this.createBasicFile(path, attr, volumeName, volumeId);
        String filename = path.getFileName().toString();
        file.setName(filename);
        file.setNumericNameList(StringUtils.removeAllNonNumericAndReturnListOfNumbers((String)filename));
        file.setExtension(FilenameUtils.getExtension((String)path.getFileName().toString()));
        file.setDirectory(Boolean.valueOf(false));
        file.setPath(FormatUtils.formatPath((String)path.getParent().toString(), (String)mountPath));
        file.setSize(Long.valueOf(attr.size()));
        file.setFileId(HashUtils.getDocumentId((String)("f-" + file.getName()), (String)file.getPath(), (Long)volumeId, (Boolean)false));
        file.setIdentificationHash(HashUtils.createMD5Hash((String)(filename + attr.lastModifiedTime().toString() + attr.size())));
        if (this.doesFileAlreadyExist(file, lastScan).booleanValue()) {
            file.setDupe(Boolean.valueOf(false));
        }
        return file;
    }

    public File createDirectory(Path path, BasicFileAttributes attr, String mountPath, String volumeName, Long volumeId) throws IOException {
        File directory = this.createBasicFile(path, attr, volumeName, volumeId);
        directory.setDirectory(Boolean.valueOf(true));
        directory.setPath(FormatUtils.formatPath((String)path.toString(), (String)mountPath));
        String filename = "";
        if (!directory.getPath().equals("/")) {
            filename = path.getFileName().toString();
        }
        directory.setName(filename);
        directory.setNumericNameList(StringUtils.removeAllNonNumericAndReturnListOfNumbers((String)filename));
        directory.setSize(Long.valueOf(0L));
        directory.setNumberOfFiles(Long.valueOf(0L));
        directory.setNumberOfFolders(Long.valueOf(0L));
        directory.setDupe(Boolean.valueOf(false));
        directory.setFileId(HashUtils.getDocumentId((String)filename, (String)directory.getPath(), (Long)volumeId, (Boolean)true));
        return directory;
    }

    public File createDirectory(Path path, File file, Date date) {
        File directory = new File();
        String filename = path.getFileName().toString();
        directory.setPath(path.toString());
        directory.setName(filename);
        directory.setNumericNameList(StringUtils.removeAllNonNumericAndReturnListOfNumbers((String)filename));
        directory.setLastModified(date);
        directory.setLastAccess(date);
        directory.setCreationDate(date);
        directory.setSize(Long.valueOf(0L));
        directory.setNumberOfFiles(Long.valueOf(0L));
        directory.setNumberOfFolders(Long.valueOf(0L));
        directory.setDupe(Boolean.valueOf(false));
        directory.setIsDeleted(Boolean.valueOf(false));
        directory.setDeleted(Boolean.valueOf(false));
        directory.setVolumeId(file.getVolumeId());
        directory.setIsDirectory(Boolean.valueOf(true));
        directory.setVolumeName(file.getVolumeName());
        directory.setIndexingDate(date);
        directory.setIdentificationHash(HashUtils.getMD5Hash((File)directory));
        directory.setFileId(HashUtils.getDocumentId((String)directory.getName(), (String)directory.getPath(), (Long)file.getVolumeId(), (Boolean)true));
        return directory;
    }

    public Boolean doesScanIsNeeded(BasicFileAttributes attr, Date lastScan) {
        if (lastScan == null) {
            return true;
        }
        Date lastAccess = new Date(attr.lastAccessTime().toMillis());
        Date lastModified = new Date(attr.lastModifiedTime().toMillis());
        Date creationDate = new Date(attr.creationTime().toMillis());
        return lastScan.before(creationDate) || lastScan.before(lastModified) || lastScan.before(lastAccess);
    }

    private Boolean doesFileAlreadyExist(File file, Date lastScan) {
        if (lastScan == null) {
            return true;
        }
        return lastScan.after(file.getCreationDate()) || lastScan.after(file.getLastModified()) || lastScan.before(file.getLastAccess());
    }

    public Boolean doesScanFolderIsNeeded(BasicFileAttributes attr, Date lastScan) {
        if (lastScan == null) {
            return true;
        }
        Date lastModified = new Date(attr.lastModifiedTime().toMillis());
        Date creationDate = new Date(attr.creationTime().toMillis());
        return lastScan.before(creationDate) || lastScan.before(lastModified);
    }

    private File createBasicFile(Path path, BasicFileAttributes attr, String volumeName, Long volumeId) throws IOException {
        PosixFileAttributes fileAttributes = Files.readAttributes(path, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        File file = new File();
        file.setOwner(fileAttributes.owner().getName());
        file.setGroup(fileAttributes.group().getName());
        file.setLastAccess(new Date(attr.lastAccessTime().toMillis()));
        file.setLastModified(new Date(attr.lastModifiedTime().toMillis()));
        file.setCreationDate(new Date(attr.creationTime().toMillis()));
        file.setIndexingDate(new Date());
        Object fileKey = attr.fileKey();
        String s = fileKey.toString();
        String inode = s.substring(s.indexOf("ino=") + 4, s.indexOf(")"));
        file.setInode(Long.valueOf(inode));
        file.setDeleted(Boolean.valueOf(false));
        file.setVolumeName(volumeName);
        file.setVolumeId(volumeId);
        return file;
    }
}

