/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.file;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.dataintell.visionapi.domain.File;
import io.dataintell.visionapi.utils.ESFileQueryUtils;
import java.time.LocalDate;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngestFileProcessor {
    private static final Logger log = LoggerFactory.getLogger(IngestFileProcessor.class);
    private final BulkProcessor bulkProcessor;
    private final LocalDate indexingDate;
    private final boolean alwaysSave;
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";

    public IngestFileProcessor(BulkProcessor bulkProcessor, LocalDate indexingDate, boolean alwaysSave) {
        this.bulkProcessor = bulkProcessor;
        this.indexingDate = indexingDate;
        this.alwaysSave = alwaysSave;
    }

    public void processFile(File file) {
        if (this.alwaysSave) {
            this.save(file);
        } else {
            this.update(file);
        }
    }

    public void closeIngestProcessor() {
        this.bulkProcessor.flush();
        try {
            boolean allSaved = this.bulkProcessor.awaitClose(5L, TimeUnit.MINUTES);
            if (allSaved) {
                log.info("All files were ingested properly");
            } else {
                log.info("There was a problem flushing the bulk processor in the required time");
            }
        }
        catch (InterruptedException e) {
            log.error("There was a problem flushing the bulk processor gracefully, reason: {}", (Object)e.getMessage(), (Object)e.getCause());
        }
    }

    private void save(File file) {
        Gson gson = new GsonBuilder().setDateFormat(DATE_FORMAT).create();
        this.bulkProcessor.add(new IndexRequest(ESFileQueryUtils.getIndexName((LocalDate)this.indexingDate)).source(gson.toJson((Object)file), XContentType.JSON).id(file.getFileId()));
    }

    private void update(File file) {
        Gson gson = new GsonBuilder().setDateFormat(DATE_FORMAT).create();
        String index = ESFileQueryUtils.getIndexName((LocalDate)this.indexingDate);
        try {
            File upsertFile = file.clone();
            upsertFile.setDupe(Boolean.valueOf(false));
            IndexRequest upsertRequest = new IndexRequest(ESFileQueryUtils.getIndexName((LocalDate)this.indexingDate)).source(gson.toJson((Object)upsertFile), XContentType.JSON).id(file.getFileId());
            this.bulkProcessor.add((DocWriteRequest)new UpdateRequest(index, file.getFileId()).doc(gson.toJson((Object)file), XContentType.JSON).upsert(upsertRequest));
        }
        catch (CloneNotSupportedException e) {
            log.warn(String.format("Unable to clone file with path [%s], name [%s] and volume [%s]", file.getPath(), file.getName(), file.getVolumeId()));
            this.bulkProcessor.add((DocWriteRequest)new UpdateRequest(index, file.getFileId()).doc(gson.toJson((Object)file), XContentType.JSON));
        }
    }
}

