/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.file;

import com.opencsv.CSVWriter;
import io.dataintell.visionapi.domain.DateHistogram;
import io.dataintell.visionapi.domain.DateIntervalType;
import io.dataintell.visionapi.domain.FieldCountSize;
import io.dataintell.visionapi.domain.IdentificationHashPaginatedResponse;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.entity.Project;
import io.dataintell.visionapi.entity.ProjectPath;
import io.dataintell.visionapi.file.BulkProcessorFactory;
import io.dataintell.visionapi.file.IngestFileProcessor;
import io.dataintell.visionapi.legacyscanner.FileBuilder;
import io.dataintell.visionapi.mapper.DateHistogramMapper;
import io.dataintell.visionapi.mapper.FieldCountSizeMapper;
import io.dataintell.visionapi.mapper.FileMapper;
import io.dataintell.visionapi.mapper.IdentificationHashPaginatedResponseMapper;
import io.dataintell.visionapi.problem.ElasticsearchIOException;
import io.dataintell.visionapi.problem.EntityNotFoundException;
import io.dataintell.visionapi.repository.ProjectRepository;
import io.dataintell.visionapi.repository.elasticsearch.FileRepository;
import io.dataintell.visionapi.service.DirectoryService;
import io.dataintell.visionapi.service.IndexService;
import io.dataintell.visionapi.utils.HashUtils;
import io.dataintell.visionapi.utils.SearchWordsFormatUtils;
import io.dataintell.visionapi.utils.SortUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.SocketTimeoutException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FileService {
    private static final Logger log = LoggerFactory.getLogger(FileService.class);
    private final FileRepository fileRepository;
    private final ProjectRepository projectRepository;
    private final FileMapper fileMapper;
    private final IdentificationHashPaginatedResponseMapper identificationHashPaginatedResponseMapper;
    private final DateHistogramMapper dateHistogramMapper;
    private final IndexService indexService;
    private final FieldCountSizeMapper fieldCountSizeMapper;
    private final BulkProcessorFactory factory;
    private final DirectoryService directoryService;
    private final FileBuilder fileBuilder;
    @Value(value="${app.scrollSize}")
    private Integer scrollSize;
    @Value(value="${app.scrollTimeToLive}")
    private Integer scrollTimeToLive;
    @Value(value="${app.csv.maxNumberOfFiles}")
    private Integer maxNumberOfFiles;
    private static final Logger logger = LoggerFactory.getLogger(FileService.class);

    public FileService(FileRepository fileRepository, ProjectRepository projectRepository, FileMapper fileMapper, IdentificationHashPaginatedResponseMapper identificationHashPaginatedResponseMapper, DateHistogramMapper dateHistogramMapper, IndexService indexService, FieldCountSizeMapper fieldCountSizeMapper, BulkProcessorFactory factory, DirectoryService directoryService, FileBuilder fileBuilder) {
        this.fileRepository = fileRepository;
        this.projectRepository = projectRepository;
        this.fileMapper = fileMapper;
        this.identificationHashPaginatedResponseMapper = identificationHashPaginatedResponseMapper;
        this.dateHistogramMapper = dateHistogramMapper;
        this.indexService = indexService;
        this.fieldCountSizeMapper = fieldCountSizeMapper;
        this.factory = factory;
        this.directoryService = directoryService;
        this.fileBuilder = fileBuilder;
    }

    public PaginatedResult<io.dataintell.visionapi.domain.File> searchFiles(String search, Boolean onlyDuplicates, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationAfter, LocalDate creationBefore, List<String> extensions, Integer page, Integer size, String sort, Long minimumSize, Long maximumSize, List<String> volumesAndPaths, List<String> ignorePatterns, List<String> tags, Boolean showOnlyDeletedFiles, Boolean isDirectory, Long minimumNumberOfFiles, Long maximumNumberOfFiles, Long minimumNumberOfFolders, Long maximumNumberOfFolders, LocalDate indexingDate) {
        Integer from = (page - 1) * size;
        String[] sortParameters = sort.split(",");
        String sortField = sortParameters[0];
        SortOrder direction = SortUtils.getESDirectionForSorting((String[])sortParameters);
        try {
            SearchResponse response = this.fileRepository.searchFiles(SearchWordsFormatUtils.getSearchWordList((String)search), onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, from, size, sortField, direction, minimumSize, maximumSize, showOnlyDeletedFiles, volumesAndPaths, ignorePatterns, tags, isDirectory, minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders, indexingDate);
            return this.fileMapper.getPaginatedResult(page, sortField, direction.toString(), response);
        }
        catch (IOException e) {
            throw new ElasticsearchIOException();
        }
    }

    public PaginatedResult<io.dataintell.visionapi.domain.File> searchFilesWithScroll(String search, Boolean onlyDuplicates, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationAfter, LocalDate creationBefore, List<String> extensions, Integer size, Integer timeToLive, String sort, Long minimumSize, Long maximumSize, Boolean showOnlyDeletedFiles, List<String> volumesAndPaths, List<String> ignorePatterns, List<String> tags, Boolean isDirectory, Long minimumNumberOfFiles, Long maximumNumberOfFiles, Long minimumNumberOfFolders, Long maximumNumberOfFolders, LocalDate indexingDate) {
        String[] sortParameters = sort.split(",");
        String sortField = sortParameters[0];
        SortOrder direction = SortUtils.getESDirectionForSorting((String[])sortParameters);
        try {
            SearchResponse response = this.fileRepository.searchFilesWithScroll(SearchWordsFormatUtils.getSearchWordList((String)search), onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, size, timeToLive, sortField, direction, minimumSize, maximumSize, showOnlyDeletedFiles, volumesAndPaths, ignorePatterns, tags, isDirectory, minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders, indexingDate);
            return this.fileMapper.getPaginatedResultWithScrollId(response);
        }
        catch (IOException e) {
            throw new ElasticsearchIOException();
        }
    }

    public List<DateHistogram> getDateHistogramBasedOnSearch(String search, Boolean onlyDuplicates, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationDateAfter, LocalDate creationDateBefore, List<String> extensions, String dateField, Long minimumSize, Long maximumSize, Boolean showOnlyDeletedFiles, DateIntervalType dateIntervalType, Integer size, List<String> volumesAndPaths, List<String> ignorePatterns, List<String> tags, Boolean isDirectory, Long minimumNumberOfFiles, Long maximumNumberOfFiles, Long minimumNumberOfFolders, Long maximumNumberOfFolders, LocalDate indexingDate) {
        try {
            SearchResponse response = this.fileRepository.getDateHistogramBasedOnSearch(SearchWordsFormatUtils.getSearchWordList((String)search), onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationDateAfter, creationDateBefore, extensions, dateField, minimumSize, maximumSize, showOnlyDeletedFiles, dateIntervalType, size, volumesAndPaths, ignorePatterns, tags, isDirectory, minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders, indexingDate);
            return this.dateHistogramMapper.convertToDTO(response);
        }
        catch (IOException e) {
            throw new ElasticsearchIOException();
        }
    }

    public List<FieldCountSize> getSumAndTotalOfAField(String search, Boolean onlyDuplicates, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationDateAfter, LocalDate creationDateBefore, List<String> extensions, String fieldName, Long minimumSize, Long maximumSize, Boolean showOnlyDeletedFiles, Integer size, List<String> volumesAndPaths, List<String> ignorePatterns, List<String> tags, Boolean isDirectory, Long minimumNumberOfFiles, Long maximumNumberOfFiles, Long minimumNumberOfFolders, Long maximumNumberOfFolders, LocalDate indexingDate) {
        try {
            SearchResponse response = this.fileRepository.getSumAndTotalOfAField(SearchWordsFormatUtils.getSearchWordList((String)search), onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationDateAfter, creationDateBefore, extensions, fieldName, minimumSize, maximumSize, showOnlyDeletedFiles, size, volumesAndPaths, ignorePatterns, tags, isDirectory, minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders, indexingDate);
            return this.fieldCountSizeMapper.convertToDTO(response);
        }
        catch (IOException e) {
            throw new ElasticsearchIOException();
        }
    }

    public Long getSizeOfSearchedFiles(String search, Boolean onlyDuplicates, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationDateAfter, LocalDate creationDateBefore, List<String> extensions, Long minimumSize, Long maximumSize, Boolean showOnlyDeletedFiles, List<String> volumesAndPaths, List<String> ignorePatterns, List<String> tags, Boolean isDirectory, Long minimumNumberOfFiles, Long maximumNumberOfFiles, Long minimumNumberOfFolders, Long maximumNumberOfFolders, LocalDate indexingDate) {
        try {
            SearchResponse response = this.fileRepository.getSizeOfSearchedFiles(SearchWordsFormatUtils.getSearchWordList((String)search), onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationDateAfter, creationDateBefore, extensions, minimumSize, maximumSize, showOnlyDeletedFiles, volumesAndPaths, ignorePatterns, tags, isDirectory, minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders, indexingDate);
            return this.convertToDTO(response);
        }
        catch (IOException e) {
            throw new ElasticsearchIOException();
        }
    }

    public void addTagForSearch(String search, Boolean onlyDuplicates, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationAfter, LocalDate creationBefore, List<String> extensions, Long minimumSize, Long maximumSize, List<String> volumesAndPaths, List<String> ignorePatterns, List<String> tags, Boolean showOnlyDeletedFiles, Boolean isDirectory, Long minimumNumberOfFiles, Long maximumNumberOfFiles, Long minimumNumberOfFolders, Long maximumNumberOfFolders, LocalDate indexingDate, String tag) {
        this.fileRepository.addTagForSearch(SearchWordsFormatUtils.getSearchWordList((String)search), onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, minimumSize, maximumSize, showOnlyDeletedFiles, volumesAndPaths, ignorePatterns, tags, isDirectory, minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders, indexingDate, tag);
    }

    public File createCsv(String search, Boolean onlyDuplicates, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationAfter, LocalDate creationBefore, List<String> extensions, String sort, Long minimumSize, Long maximumSize, Boolean showOnlyDeletedFiles, List<String> volumesAndPaths, List<String> ignorePatterns, List<String> tags, Boolean isDirectory, Long minimumNumberOfFiles, Long maximumNumberOfFiles, Long minimumNumberOfFolders, Long maximumNumberOfFolders, LocalDate indexingDate) throws IOException {
        long startTotalTime = System.currentTimeMillis();
        PaginatedResult fileList = this.searchFilesWithScroll(search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, this.scrollSize, this.scrollTimeToLive, sort, minimumSize, maximumSize, showOnlyDeletedFiles, volumesAndPaths, ignorePatterns, tags, isDirectory, minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders, indexingDate);
        return new File(this.generateCsvFileWithScrollList(fileList, false, startTotalTime));
    }

    public File createCsvOfFolders(String search, Boolean onlyDuplicates, List<Long> volumeIds, String startingPath, String owner, String group, LocalDate lastAccessAfter, LocalDate lastAccessBefore, LocalDate lastModifiedAfter, LocalDate lastModifiedBefore, LocalDate creationAfter, LocalDate creationBefore, String sort, Long minimumSize, Long maximumSize, Boolean showOnlyDeletedFolders, List<String> volumesAndPaths, List<String> ignorePatterns, List<String> tags, LocalDate indexingDate) throws IOException {
        long startTotalTime = System.currentTimeMillis();
        PaginatedResult folderList = this.searchFilesWithScroll(search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, null, this.scrollSize, this.scrollTimeToLive, sort, minimumSize, maximumSize, showOnlyDeletedFolders, volumesAndPaths, ignorePatterns, tags, Boolean.valueOf(true), null, null, null, null, indexingDate);
        return new File(this.generateCsvFileWithScrollList(folderList, true, startTotalTime));
    }

    public PaginatedResult<io.dataintell.visionapi.domain.File> getFilesOfDirectory(String directoryPath, Long volumeId, Integer page, Integer size, String sort, LocalDate indexingDate) {
        try {
            Integer from = (page - 1) * size;
            String[] sortParameters = sort.split(",");
            String sortField = sortParameters[0];
            SortOrder direction = SortUtils.getESDirectionForSorting((String[])sortParameters);
            SearchResponse response = this.fileRepository.getFilesOfDirectory(directoryPath, volumeId, from, size, sortField, direction, indexingDate);
            return this.fileMapper.getPaginatedResult(page, sortField, direction.toString(), response);
        }
        catch (IOException e) {
            throw new ElasticsearchIOException();
        }
    }

    public PaginatedResult<io.dataintell.visionapi.domain.File> getFilesByProject(Long id, Integer page, Integer elementsPerPage, Boolean onlyDuplicate, Boolean onlyArchived, Date date, String sort, LocalDate indexingDate) {
        try {
            Integer from = (page - 1) * elementsPerPage;
            String sortField = "filesize";
            SortOrder direction = SortOrder.DESC;
            Project project = (Project)this.projectRepository.findById((Object)id).orElseThrow(() -> new EntityNotFoundException(Project.class, String.valueOf(id)));
            List pathList = project.getPaths().stream().map(ProjectPath::getPath).collect(Collectors.toList());
            SearchResponse response = this.fileRepository.getFilesOfDirectories(pathList, null, onlyDuplicate, onlyArchived, date, from, elementsPerPage, sortField, direction, Boolean.valueOf(true), indexingDate);
            return this.fileMapper.getPaginatedResult(page, sortField, direction.toString(), response);
        }
        catch (IOException e) {
            throw new ElasticsearchIOException();
        }
    }

    public PaginatedResult<io.dataintell.visionapi.domain.File> getFilesByHash(String hash, Integer page, Integer size, String sort, LocalDate indexingDate, boolean isDirectory) {
        try {
            Integer from = (page - 1) * size;
            String[] sortParameters = sort.split(",");
            String sortField = sortParameters[0];
            SortOrder direction = SortUtils.getESDirectionForSorting((String[])sortParameters);
            SearchResponse response = this.fileRepository.getFilesByHash(hash, from, size, sortField, direction, indexingDate, isDirectory);
            return this.fileMapper.getPaginatedResult(page, sortField, direction.toString(), response);
        }
        catch (IOException e) {
            throw new ElasticsearchIOException();
        }
    }

    public List<String> getDuplicateIdentificationHashByVolumeIds(List<Long> volumeIds, LocalDate indexingDate, Boolean onlyDirectory) {
        ArrayList<String> hashesList = new ArrayList<String>();
        try {
            SearchResponse response = this.fileRepository.getDuplicateIdentificationHashByVolumeIds(volumeIds, indexingDate, onlyDirectory);
            Aggregations agg = response.getAggregations();
            ParsedStringTerms hashes = (ParsedStringTerms)agg.get("identificationHash");
            List hashBuckets = hashes.getBuckets();
            hashBuckets.forEach(bucket -> hashesList.add(bucket.getKeyAsString()));
        }
        catch (IOException e) {
            logger.error("Error while trying to get the list of duplicate identification hashes");
        }
        return hashesList;
    }

    public List<String> searchIdentificationHash(List<Long> volumeIds, Boolean isDuplicate, Boolean isDirectory, LocalDate lastModifiedDateBefore, LocalDate lastModifiedDateAfter, LocalDate creationDateBefore, LocalDate creationDateAfter, LocalDate indexingDate) {
        Optional response = this.fileRepository.searchIdentificationHash(volumeIds, isDuplicate, isDirectory, lastModifiedDateBefore, lastModifiedDateAfter, creationDateBefore, creationDateAfter, indexingDate);
        if (response.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> hashesList = new ArrayList<String>();
        Aggregations agg = ((SearchResponse)response.get()).getAggregations();
        ParsedStringTerms hashes = (ParsedStringTerms)agg.get("identificationHash");
        List hashBuckets = hashes.getBuckets();
        hashBuckets.forEach(bucket -> hashesList.add(bucket.getKeyAsString()));
        return hashesList;
    }

    public void tagDuplicatedFilesByHash(List<String> identificationHashes, Boolean isDuplicated, LocalDate indexingDate) throws IOException {
        try {
            this.fileRepository.tagDuplicatedFilesByHash(identificationHashes, isDuplicated, indexingDate);
        }
        catch (SocketTimeoutException e) {
            this.indexService.handleLongProcesses("indices:data/write/update/byquery");
        }
    }

    public void tagDeletedFilesByVolumesAndOlderThanIndexingDate(List<Long> volumeIds, Date scanDate, LocalDate indexingDate) {
        logger.info("About to tag deleted files for volumes {}", volumeIds);
        long startTime = System.currentTimeMillis();
        this.fileRepository.tagDeletedFilesByVolumesAndOlderThanIndexingDate(volumeIds, scanDate, indexingDate);
        long timeElapsedForTagging = System.currentTimeMillis() - startTime;
        logger.info("Finished tagging deleted files took {} ms", (Object)timeElapsedForTagging);
    }

    public IdentificationHashPaginatedResponse getAllIdentificationHash(String afterKey, Boolean tagDuplicateFiles, LocalDate lastModifiedBefore, LocalDate lastModifiedAfter, LocalDate indexingDate) throws IOException {
        SearchResponse searchResponse = this.fileRepository.getIdentificationHash(this.scrollSize, afterKey, tagDuplicateFiles, lastModifiedBefore, lastModifiedAfter, indexingDate);
        return this.identificationHashPaginatedResponseMapper.convertToDto(searchResponse);
    }

    public PaginatedResult<io.dataintell.visionapi.domain.File> getNextListWithScroll(String scrollId) throws IOException {
        SearchResponse response = this.fileRepository.getNextListWithScroll(scrollId, this.scrollTimeToLive);
        return this.fileMapper.getPaginatedResultWithScrollId(response);
    }

    public void clearScroll(String scrollId) {
        this.fileRepository.clearScroll(scrollId);
    }

    public Long getNumberOfDeletedFiles(String path, Long numberOfFiles, Long volumeId, LocalDate indexingDate) throws IOException {
        SearchResponse searchResponse = this.fileRepository.getFilesOfDirectories(Collections.singletonList(path), Collections.singletonList(volumeId), Boolean.valueOf(false), Boolean.valueOf(false), null, Integer.valueOf(0), Integer.valueOf(0), "size", SortOrder.ASC, Boolean.valueOf(true), indexingDate);
        return searchResponse.getHits().getTotalHits().value - numberOfFiles;
    }

    public PaginatedResult<io.dataintell.visionapi.domain.File> getPotentialDeletedFiles(String path, Long volumeId, Date scanDate, Integer size, LocalDate indexingDate) throws IOException {
        SearchResponse searchResponse = this.fileRepository.getFilesOfDirectoryIndexedBefore(path, volumeId, scanDate, size, indexingDate, this.scrollTimeToLive);
        return this.fileMapper.getPaginatedResultWithScrollId(searchResponse);
    }

    public void removeDeletedFilesOlderThan(Integer numberOfDays) throws IOException {
        LocalDate date = LocalDate.now().minusDays(numberOfDays.intValue());
        this.fileRepository.removeDeletedFilesOlderThan(date, LocalDate.now());
    }

    public void update(String id, io.dataintell.visionapi.domain.File file, LocalDate indexingDate) {
        this.fileRepository.updateById(id, file, indexingDate).orElseThrow(ElasticsearchIOException::new);
    }

    public List<String> getTags(Integer size, LocalDate indexingDate) {
        ArrayList<String> tagsList = new ArrayList<String>();
        try {
            SearchResponse response = this.fileRepository.getTags(size, indexingDate);
            Aggregations agg = response.getAggregations();
            ParsedStringTerms tags = (ParsedStringTerms)agg.get("customTag");
            List tagBuckets = tags.getBuckets();
            tagBuckets.forEach(bucket -> tagsList.add(bucket.getKeyAsString()));
        }
        catch (IOException e) {
            logger.error("Error while trying to get the list of tags");
        }
        return tagsList;
    }

    public Set<io.dataintell.visionapi.domain.File> indexFiles(List<io.dataintell.visionapi.domain.File> fileList, LocalDate indexingDate) {
        IngestFileProcessor ingestFileProcessor = new IngestFileProcessor(this.factory.makeBulkProcessor(), indexingDate, false);
        HashSet<io.dataintell.visionapi.domain.File> folders = new HashSet<io.dataintell.visionapi.domain.File>();
        Date date = new Date();
        for (io.dataintell.visionapi.domain.File file : fileList) {
            if (file.getIsDirectory().booleanValue()) {
                file.setIdentificationHash(HashUtils.getMD5Hash((io.dataintell.visionapi.domain.File)file));
                file.setFileId(HashUtils.getDocumentId((String)file.getName(), (String)file.getPath(), (Long)file.getVolumeId(), (Boolean)true));
            } else {
                file.setIdentificationHash(HashUtils.createMD5Hash((String)(file.getName() + file.getLastModified().toString() + file.getSize())));
                file.setFileId(HashUtils.getDocumentId((String)("f-" + file.getName()), (String)file.getPath(), (Long)file.getVolumeId(), (Boolean)false));
            }
            file.setIndexingDate(new Date());
            ingestFileProcessor.processFile(file);
            Path filePath = Path.of(file.getPath(), new String[0]);
            while (!filePath.toString().equals("/")) {
                try {
                    io.dataintell.visionapi.domain.File parentFolder = this.directoryService.getDirectory(filePath.getFileName().toString(), filePath.toString(), file.getVolumeId(), indexingDate);
                    if (parentFolder == null) {
                        parentFolder = this.fileBuilder.createDirectory(filePath, file, date);
                    }
                    folders.add(parentFolder);
                    parentFolder.setIndexingDate(new Date());
                    ingestFileProcessor.processFile(parentFolder);
                }
                catch (IOException e) {
                    log.warn(String.format("Error while getting the  directory [%s]", filePath));
                }
                filePath = filePath.getParent();
            }
        }
        ingestFileProcessor.closeIngestProcessor();
        return folders;
    }

    public void updateParentFolders(Set<io.dataintell.visionapi.domain.File> folders, LocalDate indexingDate) {
        IngestFileProcessor ingestFileProcessor = new IngestFileProcessor(this.factory.makeBulkProcessor(), indexingDate, false);
        for (io.dataintell.visionapi.domain.File folder : folders) {
            Long numberOfFiles = this.searchFiles("", Boolean.valueOf(false), Collections.singletonList(folder.getVolumeId()), folder.getPath(), null, null, null, null, null, null, null, null, null, Integer.valueOf(1), Integer.valueOf(0), "size", null, null, null, null, null, null, Boolean.valueOf(false), null, null, null, null, indexingDate).getTotal();
            Long size = this.getSizeOfSearchedFiles("", Boolean.valueOf(false), Collections.singletonList(folder.getVolumeId()), folder.getPath(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(false), null, null, null, null, indexingDate);
            Long numberOfFolders = this.searchFiles("", Boolean.valueOf(false), Collections.singletonList(folder.getVolumeId()), folder.getPath(), null, null, null, null, null, null, null, null, null, Integer.valueOf(1), Integer.valueOf(0), "size", null, null, null, null, null, null, Boolean.valueOf(true), null, null, null, null, indexingDate).getTotal();
            folder.setNumberOfFiles(numberOfFiles);
            folder.setNumberOfFolders(numberOfFolders);
            folder.setSize(size);
            folder.setIndexingDate(new Date());
            folder.setIdentificationHash(HashUtils.getMD5Hash((io.dataintell.visionapi.domain.File)folder));
            ingestFileProcessor.processFile(folder);
        }
        ingestFileProcessor.closeIngestProcessor();
    }

    private String generateCsvFileWithScrollList(PaginatedResult<io.dataintell.visionapi.domain.File> list, boolean isDirectory, long startTotalTime) throws IOException {
        String filenameForFiles = String.format("/tmp/searchFilesExport-%s.csv", new Date());
        String filenameForFolders = String.format("/tmp/searchFoldersExport-%s.csv", new Date());
        String filename = isDirectory ? filenameForFolders : filenameForFiles;
        this.createCsvFile(filename, false, list.getElements(), isDirectory);
        Integer fileCount = list.getSize();
        long timeScroll = System.currentTimeMillis() - startTotalTime;
        long numberOfScrolls = list.getTotal() % (long)this.scrollSize.intValue() == 0L ? list.getTotal() / (long)this.scrollSize.intValue() : list.getTotal() / (long)this.scrollSize.intValue() + 1L;
        logger.debug(String.format("CreateCsv (get first file list with scroll) [scroll list %s of %s, file count = %s] took %s ms", 1, numberOfScrolls, list.getSize(), timeScroll));
        if (fileCount >= this.maxNumberOfFiles) {
            return filename;
        }
        Integer countScroll = 1;
        do {
            long startScroll = System.currentTimeMillis();
            if ((list = this.getNextListWithScroll(list.getScrollId())).getSize() == 0) break;
            this.createCsvFile(filename, true, list.getElements(), isDirectory);
            fileCount = fileCount + list.getSize();
            Integer n = countScroll;
            Integer n2 = countScroll = Integer.valueOf(countScroll + 1);
            timeScroll = System.currentTimeMillis() - startScroll;
            logger.debug(String.format("CreateCsv (get next file list with scroll) [scroll list %s of %s, file count = %s] took %s ms", countScroll, numberOfScrolls, fileCount, timeScroll));
        } while (fileCount < this.maxNumberOfFiles);
        long time = System.currentTimeMillis() - startTotalTime;
        logger.debug(String.format("CreateCsv [file count = %s] took %s ms (total time)", fileCount, time));
        this.clearScroll(list.getScrollId());
        return filename;
    }

    private void createCsvFile(String filename, boolean append, List<io.dataintell.visionapi.domain.File> fileList, boolean isDirectory) throws IOException {
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(filename, append));
        if (!append) {
            String[] fileHeader = new String[]{"File name", "Extension", "Path", "Path (UNC)", "Size (Bytes)", "Size", "Owner", "Group", "Volume name", "Is duplicated", "Is deleted", "Creation date", "Modified date", "Last access date", "Indexing date", "Inode", "Tag"};
            String[] folderHeader = new String[]{"Folder name", "Path", "Path (UNC)", "Size (Bytes)", "Size", "Number of files", "Number of folders", "Owner", "Group", "Volume name", "Is duplicated", "Is deleted", "Creation date", "Modified date", "Last access date", "Indexing date", "Inode", "Tag"};
            writer.writeNext(isDirectory ? folderHeader : fileHeader);
        }
        fileList.forEach(file -> writer.writeNext(isDirectory ? this.convertFolderToList(file) : this.convertToList(file)));
        writer.close();
    }

    private String[] convertToList(io.dataintell.visionapi.domain.File file) {
        String[] fileAsList = new String[17];
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Path fullPath = Paths.get(file.getPath(), file.getName());
        fileAsList[0] = file.getName();
        fileAsList[1] = file.getExtension();
        fileAsList[2] = fullPath.toString();
        fileAsList[3] = String.format("\\\\%s%s", file.getVolumeName(), FilenameUtils.separatorsToWindows((String)fullPath.toString()));
        fileAsList[4] = file.getSize().toString();
        fileAsList[5] = FileUtils.byteCountToDisplaySize((long)file.getSize());
        fileAsList[6] = file.getOwner() != null ? file.getOwner() : "N/A";
        fileAsList[7] = file.getGroup() != null ? file.getGroup() : "N/A";
        fileAsList[8] = file.getVolumeName();
        fileAsList[9] = file.getDupe() != null ? file.getDupe().toString() : "N/A";
        fileAsList[10] = file.getDeleted().toString();
        fileAsList[11] = file.getCreationDate() != null ? dateFormat.format(file.getCreationDate()) : "N/A";
        fileAsList[12] = dateFormat.format(file.getLastModified());
        fileAsList[13] = file.getLastAccess() != null ? dateFormat.format(file.getLastAccess()) : "N/A";
        fileAsList[14] = dateFormat.format(file.getIndexingDate());
        fileAsList[15] = file.getInode() != null ? file.getInode().toString() : "N/A";
        fileAsList[16] = file.getTag();
        return fileAsList;
    }

    private String[] convertFolderToList(io.dataintell.visionapi.domain.File folder) {
        String[] folderAsList = new String[18];
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Path fullPath = Paths.get(folder.getPath(), new String[0]);
        folderAsList[0] = folder.getName();
        folderAsList[1] = fullPath.toString();
        folderAsList[2] = String.format("\\\\%s%s", folder.getVolumeName(), FilenameUtils.separatorsToWindows((String)fullPath.toString()));
        folderAsList[3] = folder.getSize().toString();
        folderAsList[4] = FileUtils.byteCountToDisplaySize((long)folder.getSize());
        folderAsList[5] = folder.getNumberOfFiles().toString();
        folderAsList[6] = folder.getNumberOfFolders().toString();
        folderAsList[7] = folder.getOwner() != null ? folder.getOwner() : "N/A";
        folderAsList[8] = folder.getGroup() != null ? folder.getGroup() : "N/A";
        folderAsList[9] = folder.getVolumeName();
        folderAsList[10] = folder.getDupe() != null ? folder.getDupe().toString() : "N/A";
        folderAsList[11] = folder.getDeleted().toString();
        folderAsList[12] = folder.getCreationDate() != null ? dateFormat.format(folder.getCreationDate()) : "N/A";
        folderAsList[13] = dateFormat.format(folder.getLastModified());
        folderAsList[14] = folder.getLastAccess() != null ? dateFormat.format(folder.getLastAccess()) : "N/A";
        folderAsList[15] = dateFormat.format(folder.getIndexingDate());
        folderAsList[16] = folder.getInode() != null ? folder.getInode().toString() : "N/A";
        folderAsList[17] = folder.getTag();
        return folderAsList;
    }

    private Long convertToDTO(SearchResponse response) {
        Sum agg = (Sum)response.getAggregations().get("size");
        Double totalSize = agg.getValue();
        return totalSize.longValue();
    }
}

