/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.file;

import io.dataintell.visionapi.file.BulkProcessorFactory;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BulkProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(BulkProcessorFactory.class);
    private final Integer bulkNumberOfDocuments;
    private final Integer bulkNumberOfThreads;
    private final RestHighLevelClient elasticsearchClient;

    public BulkProcessorFactory(@Value(value="${es.bulk.documents}") Integer bulkNumberOfDocuments, @Value(value="${es.bulk.threads}") Integer bulkNumberOfThreads, RestHighLevelClient elasticsearchClient) {
        this.bulkNumberOfDocuments = bulkNumberOfDocuments;
        this.bulkNumberOfThreads = bulkNumberOfThreads;
        this.elasticsearchClient = elasticsearchClient;
    }

    public BulkProcessor makeBulkProcessor() {
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        BulkProcessor.Builder builder = BulkProcessor.builder((request, bulkListener) -> this.elasticsearchClient.bulkAsync(request, RequestOptions.DEFAULT, bulkListener), (BulkProcessor.Listener)listener);
        builder.setBulkActions(this.bulkNumberOfDocuments.intValue());
        builder.setConcurrentRequests(this.bulkNumberOfThreads.intValue());
        builder.setFlushInterval(TimeValue.timeValueSeconds((long)10L));
        builder.setBackoffPolicy(BackoffPolicy.constantBackoff((TimeValue)TimeValue.timeValueSeconds((long)1L), (int)3));
        return builder.build();
    }
}

