/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.entity;

import io.dataintell.visionapi.entity.RoleEntity;
import io.dataintell.visionapi.entity.audit.DateAudit;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="app_user", uniqueConstraints={@UniqueConstraint(columnNames={"username"}), @UniqueConstraint(columnNames={"email"})})
public class UserEntity
extends DateAudit {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String name;
    @Size(min=3, max=255)
    private @Size(min=3, max=255) String username;
    @NotBlank
    @Size(max=255)
    @Email
    private @NotBlank @Size(max=255) @Email String email;
    @Size(min=6, max=255)
    private @Size(min=6, max=255) String password;
    @NotNull
    private Boolean eulaValidation;
    @ManyToMany
    @JoinTable(name="user_role", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    private List<RoleEntity> roleEntities;

    public UserEntity(String name, String username, String email, String password, Boolean eulaValidation) {
        this.name = name;
        this.username = username;
        this.email = email;
        this.password = password;
        this.eulaValidation = eulaValidation;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUsername() {
        return this.username;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getEulaValidation() {
        return this.eulaValidation;
    }

    public List<RoleEntity> getRoleEntities() {
        return this.roleEntities;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEulaValidation(Boolean eulaValidation) {
        this.eulaValidation = eulaValidation;
    }

    public void setRoleEntities(List<RoleEntity> roleEntities) {
        this.roleEntities = roleEntities;
    }

    public UserEntity(Long id, String name, String username, String email, String password, Boolean eulaValidation, List<RoleEntity> roleEntities) {
        this.id = id;
        this.name = name;
        this.username = username;
        this.email = email;
        this.password = password;
        this.eulaValidation = eulaValidation;
        this.roleEntities = roleEntities;
    }

    public UserEntity() {
    }
}

