/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.entity;

import io.dataintell.visionapi.entity.ProjectPath;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@EntityListeners(value={AuditingEntityListener.class})
@Table(name="project")
public class Project
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Length(max=255)
    private @Length(max=255) String description;
    @NotNull
    @Length(max=255)
    private @NotNull @Length(max=255) String name;
    @NotNull(message="must be a number greater than or equal to 0")
    @Min(value=0L)
    private @NotNull(message="must be a number greater than or equal to 0") @Min(value=0L) Long allocatedSize;
    @CreatedDate
    private LocalDateTime creationDate;
    @LastModifiedDate
    private LocalDateTime modificationDate;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="project_id", referencedColumnName="id")
    private Set<ProjectPath> paths;

    public Long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public Long getAllocatedSize() {
        return this.allocatedSize;
    }

    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    public LocalDateTime getModificationDate() {
        return this.modificationDate;
    }

    public Set<ProjectPath> getPaths() {
        return this.paths;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAllocatedSize(Long allocatedSize) {
        this.allocatedSize = allocatedSize;
    }

    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public void setModificationDate(LocalDateTime modificationDate) {
        this.modificationDate = modificationDate;
    }

    public void setPaths(Set<ProjectPath> paths) {
        this.paths = paths;
    }

    public Project(Long id, String description, String name, Long allocatedSize, LocalDateTime creationDate, LocalDateTime modificationDate, Set<ProjectPath> paths) {
        this.id = id;
        this.description = description;
        this.name = name;
        this.allocatedSize = allocatedSize;
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
        this.paths = paths;
    }

    public Project() {
    }
}

