/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.domain.search;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

public class StringFilter {
    @Schema(title="Exact Value", description="Must be the exact value of the field", example="DataIntell")
    String value;
    @Schema(title="Starting With", description="Filter files with a field starting with a specific string.", example="DataIn")
    String startingWith;
    @Schema(title="Wildcard", description="Filter files with wildcards. This parameter supports two wildcard operators: ?, which matches any single character and *, which can match zero or more characters, including an empty one", example="D?taInt*")
    String wildcard;
    @Schema(title="Regex", description="Filter files with regex. This parameter supports Elasticsearch Regex query. These reserved characters might need to be escaped with backslash character \\ Reserved characters . ? + * | { } [ ] ( ) \" \\ ", example="foo<1-100>")
    String regex;
    @Schema(title="Exact Values", description="Same as value but act as a OR with multiple values", example="['DataIntell','DataIntell2']")
    List<String> values;

    public String getValue() {
        return this.value;
    }

    public String getStartingWith() {
        return this.startingWith;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getRegex() {
        return this.regex;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setStartingWith(String startingWith) {
        this.startingWith = startingWith;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringFilter)) {
            return false;
        }
        StringFilter other = (StringFilter)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$startingWith = this.getStartingWith();
        String other$startingWith = other.getStartingWith();
        if (this$startingWith == null ? other$startingWith != null : !this$startingWith.equals(other$startingWith)) {
            return false;
        }
        String this$wildcard = this.getWildcard();
        String other$wildcard = other.getWildcard();
        if (this$wildcard == null ? other$wildcard != null : !this$wildcard.equals(other$wildcard)) {
            return false;
        }
        String this$regex = this.getRegex();
        String other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !this$regex.equals(other$regex)) {
            return false;
        }
        List this$values = this.getValues();
        List other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $startingWith = this.getStartingWith();
        result = result * 59 + ($startingWith == null ? 43 : $startingWith.hashCode());
        String $wildcard = this.getWildcard();
        result = result * 59 + ($wildcard == null ? 43 : $wildcard.hashCode());
        String $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
        List $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "StringFilter(value=" + this.getValue() + ", startingWith=" + this.getStartingWith() + ", wildcard=" + this.getWildcard() + ", regex=" + this.getRegex() + ", values=" + this.getValues() + ")";
    }
}

