/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.domain;

import io.dataintell.visionapi.domain.PaginatedResult;
import java.util.List;
import org.springframework.data.domain.Page;

public class PaginatedResult<T> {
    private Integer page;
    private Long total;
    private Integer size;
    private List<T> elements;
    private String sort;
    private String direction;
    private String scrollId;

    public PaginatedResult(Page<T> elements, String direction, String sort, Integer requestedSize) {
        this.direction = direction;
        this.sort = sort;
        this.size = requestedSize;
        this.total = elements.getTotalElements();
        this.page = elements.getNumber() + 1;
        this.elements = elements.getContent();
    }

    public static <T> PaginatedResultBuilder<T> builder() {
        return new PaginatedResultBuilder();
    }

    public Integer getPage() {
        return this.page;
    }

    public Long getTotal() {
        return this.total;
    }

    public Integer getSize() {
        return this.size;
    }

    public List<T> getElements() {
        return this.elements;
    }

    public String getSort() {
        return this.sort;
    }

    public String getDirection() {
        return this.direction;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setElements(List<T> elements) {
        this.elements = elements;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public void setScrollId(String scrollId) {
        this.scrollId = scrollId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaginatedResult)) {
            return false;
        }
        PaginatedResult other = (PaginatedResult)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$page = this.getPage();
        Integer other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        List this$elements = this.getElements();
        List other$elements = other.getElements();
        if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
            return false;
        }
        String this$sort = this.getSort();
        String other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !this$sort.equals(other$sort)) {
            return false;
        }
        String this$direction = this.getDirection();
        String other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !this$direction.equals(other$direction)) {
            return false;
        }
        String this$scrollId = this.getScrollId();
        String other$scrollId = other.getScrollId();
        return !(this$scrollId == null ? other$scrollId != null : !this$scrollId.equals(other$scrollId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaginatedResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        List $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        String $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
        String $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : $direction.hashCode());
        String $scrollId = this.getScrollId();
        result = result * 59 + ($scrollId == null ? 43 : $scrollId.hashCode());
        return result;
    }

    public String toString() {
        return "PaginatedResult(page=" + this.getPage() + ", total=" + this.getTotal() + ", size=" + this.getSize() + ", elements=" + this.getElements() + ", sort=" + this.getSort() + ", direction=" + this.getDirection() + ", scrollId=" + this.getScrollId() + ")";
    }

    public PaginatedResult() {
    }

    public PaginatedResult(Integer page, Long total, Integer size, List<T> elements, String sort, String direction, String scrollId) {
        this.page = page;
        this.total = total;
        this.size = size;
        this.elements = elements;
        this.sort = sort;
        this.direction = direction;
        this.scrollId = scrollId;
    }
}

