/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.domain;

import io.dataintell.visionapi.domain.BasicStatistic;
import io.dataintell.visionapi.domain.DetailedProjectPath;
import io.dataintell.visionapi.domain.FolderGroup;
import io.dataintell.visionapi.domain.StatisticType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DetailedProject {
    private Long id;
    private String description;
    private String name;
    private Long version;
    private Long size;
    private Long numberOfFiles;
    private Long allocatedSize;
    private Date lastAccessDate;
    private Date lastModifiedDate;
    private Date indexingDate;
    private List<DetailedProjectPath> detailedProjectPaths;

    public List<FolderGroup> getFolderGroups() {
        ArrayList<FolderGroup> folderGroupsList = new ArrayList<FolderGroup>();
        if (this.detailedProjectPaths != null) {
            Map<Long, List<DetailedProjectPath>> folderGroups = this.detailedProjectPaths.stream().collect(Collectors.groupingBy(DetailedProjectPath::getVolumeId));
            folderGroups.forEach((volumeId, folders) -> {
                long sizeInBytes = folders.stream().mapToLong(DetailedProjectPath::getSize).sum();
                long duplicateFilesSizeInBytes = folders.stream().mapToLong(f -> f.getStatistics().isEmpty() ? 0L : ((BasicStatistic)f.getStatistics().get(StatisticType.DUPLICATE)).getSize()).sum();
                long unusedFilesOneWeekSizeInBytes = folders.stream().mapToLong(f -> f.getStatistics().containsKey(StatisticType.LAST_ACCESS_ONE_WEEK) ? ((BasicStatistic)f.getStatistics().get(StatisticType.LAST_ACCESS_ONE_WEEK)).getSize() : 0L).sum();
                long unusedFilesOneMonthSizeInBytes = folders.stream().mapToLong(f -> f.getStatistics().containsKey(StatisticType.LAST_ACCESS_ONE_MONTH) ? ((BasicStatistic)f.getStatistics().get(StatisticType.LAST_ACCESS_ONE_MONTH)).getSize() : 0L).sum();
                long unusedFilesThreeMonthsSizeInBytes = folders.stream().mapToLong(f -> f.getStatistics().containsKey(StatisticType.LAST_ACCESS_THREE_MONTH) ? ((BasicStatistic)f.getStatistics().get(StatisticType.LAST_ACCESS_THREE_MONTH)).getSize() : 0L).sum();
                long unusedFilesSixMonthsSizeInBytes = folders.stream().mapToLong(f -> f.getStatistics().containsKey(StatisticType.LAST_ACCESS_SIX_MONTH) ? ((BasicStatistic)f.getStatistics().get(StatisticType.LAST_ACCESS_SIX_MONTH)).getSize() : 0L).sum();
                long unusedFilesOneYearSizeInBytes = folders.stream().mapToLong(f -> f.getStatistics().containsKey(StatisticType.LAST_ACCESS_ONE_YEAR) ? ((BasicStatistic)f.getStatistics().get(StatisticType.LAST_ACCESS_ONE_YEAR)).getSize() : 0L).sum();
                long unmodifiedFilesOneWeekSizeInBytes = folders.stream().mapToLong(f -> f.getStatistics().containsKey(StatisticType.LAST_MODIFIED_ONE_WEEK) ? ((BasicStatistic)f.getStatistics().get(StatisticType.LAST_MODIFIED_ONE_WEEK)).getSize() : 0L).sum();
                long unmodifiedFilesOneMonthSizeInBytes = folders.stream().mapToLong(f -> f.getStatistics().containsKey(StatisticType.LAST_MODIFIED_ONE_MONTH) ? ((BasicStatistic)f.getStatistics().get(StatisticType.LAST_MODIFIED_ONE_MONTH)).getSize() : 0L).sum();
                long unmodifiedFilesThreeMonthsSizeInBytes = folders.stream().mapToLong(f -> f.getStatistics().containsKey(StatisticType.LAST_MODIFIED_THREE_MONTH) ? ((BasicStatistic)f.getStatistics().get(StatisticType.LAST_MODIFIED_THREE_MONTH)).getSize() : 0L).sum();
                long unmodifiedFilesSixMonthsSizeInBytes = folders.stream().mapToLong(f -> f.getStatistics().containsKey(StatisticType.LAST_MODIFIED_SIX_MONTH) ? ((BasicStatistic)f.getStatistics().get(StatisticType.LAST_MODIFIED_SIX_MONTH)).getSize() : 0L).sum();
                long unmodifiedFilesOneYearSizeInBytes = folders.stream().mapToLong(f -> f.getStatistics().containsKey(StatisticType.LAST_MODIFIED_ONE_YEAR) ? ((BasicStatistic)f.getStatistics().get(StatisticType.LAST_MODIFIED_ONE_YEAR)).getSize() : 0L).sum();
                folderGroupsList.add(new FolderGroup(volumeId.longValue(), ((DetailedProjectPath)folders.get(0)).getVolumeName(), sizeInBytes, duplicateFilesSizeInBytes, unusedFilesOneWeekSizeInBytes, unusedFilesOneMonthSizeInBytes, unusedFilesThreeMonthsSizeInBytes, unusedFilesSixMonthsSizeInBytes, unusedFilesOneYearSizeInBytes, unmodifiedFilesOneWeekSizeInBytes, unmodifiedFilesOneMonthSizeInBytes, unmodifiedFilesThreeMonthsSizeInBytes, unmodifiedFilesSixMonthsSizeInBytes, unmodifiedFilesOneYearSizeInBytes, folders));
            });
        }
        return folderGroupsList;
    }

    public Long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public Long getVersion() {
        return this.version;
    }

    public Long getSize() {
        return this.size;
    }

    public Long getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public Long getAllocatedSize() {
        return this.allocatedSize;
    }

    public Date getLastAccessDate() {
        return this.lastAccessDate;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Date getIndexingDate() {
        return this.indexingDate;
    }

    public List<DetailedProjectPath> getDetailedProjectPaths() {
        return this.detailedProjectPaths;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public void setNumberOfFiles(Long numberOfFiles) {
        this.numberOfFiles = numberOfFiles;
    }

    public void setAllocatedSize(Long allocatedSize) {
        this.allocatedSize = allocatedSize;
    }

    public void setLastAccessDate(Date lastAccessDate) {
        this.lastAccessDate = lastAccessDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setIndexingDate(Date indexingDate) {
        this.indexingDate = indexingDate;
    }

    public void setDetailedProjectPaths(List<DetailedProjectPath> detailedProjectPaths) {
        this.detailedProjectPaths = detailedProjectPaths;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetailedProject)) {
            return false;
        }
        DetailedProject other = (DetailedProject)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Long this$size = this.getSize();
        Long other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        Long this$numberOfFiles = this.getNumberOfFiles();
        Long other$numberOfFiles = other.getNumberOfFiles();
        if (this$numberOfFiles == null ? other$numberOfFiles != null : !((Object)this$numberOfFiles).equals(other$numberOfFiles)) {
            return false;
        }
        Long this$allocatedSize = this.getAllocatedSize();
        Long other$allocatedSize = other.getAllocatedSize();
        if (this$allocatedSize == null ? other$allocatedSize != null : !((Object)this$allocatedSize).equals(other$allocatedSize)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Date this$lastAccessDate = this.getLastAccessDate();
        Date other$lastAccessDate = other.getLastAccessDate();
        if (this$lastAccessDate == null ? other$lastAccessDate != null : !((Object)this$lastAccessDate).equals(other$lastAccessDate)) {
            return false;
        }
        Date this$lastModifiedDate = this.getLastModifiedDate();
        Date other$lastModifiedDate = other.getLastModifiedDate();
        if (this$lastModifiedDate == null ? other$lastModifiedDate != null : !((Object)this$lastModifiedDate).equals(other$lastModifiedDate)) {
            return false;
        }
        Date this$indexingDate = this.getIndexingDate();
        Date other$indexingDate = other.getIndexingDate();
        if (this$indexingDate == null ? other$indexingDate != null : !((Object)this$indexingDate).equals(other$indexingDate)) {
            return false;
        }
        List this$detailedProjectPaths = this.getDetailedProjectPaths();
        List other$detailedProjectPaths = other.getDetailedProjectPaths();
        return !(this$detailedProjectPaths == null ? other$detailedProjectPaths != null : !((Object)this$detailedProjectPaths).equals(other$detailedProjectPaths));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DetailedProject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Long $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        Long $numberOfFiles = this.getNumberOfFiles();
        result = result * 59 + ($numberOfFiles == null ? 43 : ((Object)$numberOfFiles).hashCode());
        Long $allocatedSize = this.getAllocatedSize();
        result = result * 59 + ($allocatedSize == null ? 43 : ((Object)$allocatedSize).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Date $lastAccessDate = this.getLastAccessDate();
        result = result * 59 + ($lastAccessDate == null ? 43 : ((Object)$lastAccessDate).hashCode());
        Date $lastModifiedDate = this.getLastModifiedDate();
        result = result * 59 + ($lastModifiedDate == null ? 43 : ((Object)$lastModifiedDate).hashCode());
        Date $indexingDate = this.getIndexingDate();
        result = result * 59 + ($indexingDate == null ? 43 : ((Object)$indexingDate).hashCode());
        List $detailedProjectPaths = this.getDetailedProjectPaths();
        result = result * 59 + ($detailedProjectPaths == null ? 43 : ((Object)$detailedProjectPaths).hashCode());
        return result;
    }

    public String toString() {
        return "DetailedProject(id=" + this.getId() + ", description=" + this.getDescription() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", size=" + this.getSize() + ", numberOfFiles=" + this.getNumberOfFiles() + ", allocatedSize=" + this.getAllocatedSize() + ", lastAccessDate=" + this.getLastAccessDate() + ", lastModifiedDate=" + this.getLastModifiedDate() + ", indexingDate=" + this.getIndexingDate() + ", detailedProjectPaths=" + this.getDetailedProjectPaths() + ")";
    }

    public DetailedProject(Long id, String description, String name, Long version, Long size, Long numberOfFiles, Long allocatedSize, Date lastAccessDate, Date lastModifiedDate, Date indexingDate, List<DetailedProjectPath> detailedProjectPaths) {
        this.id = id;
        this.description = description;
        this.name = name;
        this.version = version;
        this.size = size;
        this.numberOfFiles = numberOfFiles;
        this.allocatedSize = allocatedSize;
        this.lastAccessDate = lastAccessDate;
        this.lastModifiedDate = lastModifiedDate;
        this.indexingDate = indexingDate;
        this.detailedProjectPaths = detailedProjectPaths;
    }

    public DetailedProject() {
    }
}

