/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.domain;

import io.dataintell.visionapi.domain.Bucket;
import io.dataintell.visionapi.domain.BucketType;
import io.dataintell.visionapi.entity.StoragePriceEntity;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class Bucket {
    private final int id;
    @NotEmpty
    private final String name;
    @NotEmpty
    private final String description;
    @NotEmpty
    private final String region;
    private final BucketType type;
    private final Long volumeSettingId;
    @NotNull
    private final Integer awsCredentialsId;
    @NotNull
    private final StoragePriceEntity storagePrice;

    public String getBucketName() {
        if (this.type == BucketType.ORACLE_OBJECT_STORAGE) {
            return this.name.substring(this.name.indexOf(".") + 1);
        }
        return this.name;
    }

    public String getNamespace() {
        if (this.type == BucketType.ORACLE_OBJECT_STORAGE) {
            return this.name.split("\\.")[0];
        }
        return this.name;
    }

    Bucket(int id, String name, String description, String region, BucketType type, Long volumeSettingId, Integer awsCredentialsId, StoragePriceEntity storagePrice) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.region = region;
        this.type = type;
        this.volumeSettingId = volumeSettingId;
        this.awsCredentialsId = awsCredentialsId;
        this.storagePrice = storagePrice;
    }

    public static BucketBuilder builder() {
        return new BucketBuilder();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRegion() {
        return this.region;
    }

    public BucketType getType() {
        return this.type;
    }

    public Long getVolumeSettingId() {
        return this.volumeSettingId;
    }

    public Integer getAwsCredentialsId() {
        return this.awsCredentialsId;
    }

    public StoragePriceEntity getStoragePrice() {
        return this.storagePrice;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bucket)) {
            return false;
        }
        Bucket other = (Bucket)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        Long this$volumeSettingId = this.getVolumeSettingId();
        Long other$volumeSettingId = other.getVolumeSettingId();
        if (this$volumeSettingId == null ? other$volumeSettingId != null : !((Object)this$volumeSettingId).equals(other$volumeSettingId)) {
            return false;
        }
        Integer this$awsCredentialsId = this.getAwsCredentialsId();
        Integer other$awsCredentialsId = other.getAwsCredentialsId();
        if (this$awsCredentialsId == null ? other$awsCredentialsId != null : !((Object)this$awsCredentialsId).equals(other$awsCredentialsId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        BucketType this$type = this.getType();
        BucketType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        StoragePriceEntity this$storagePrice = this.getStoragePrice();
        StoragePriceEntity other$storagePrice = other.getStoragePrice();
        return !(this$storagePrice == null ? other$storagePrice != null : !this$storagePrice.equals(other$storagePrice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Bucket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        Long $volumeSettingId = this.getVolumeSettingId();
        result = result * 59 + ($volumeSettingId == null ? 43 : ((Object)$volumeSettingId).hashCode());
        Integer $awsCredentialsId = this.getAwsCredentialsId();
        result = result * 59 + ($awsCredentialsId == null ? 43 : ((Object)$awsCredentialsId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        BucketType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        StoragePriceEntity $storagePrice = this.getStoragePrice();
        result = result * 59 + ($storagePrice == null ? 43 : $storagePrice.hashCode());
        return result;
    }

    public String toString() {
        return "Bucket(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", region=" + this.getRegion() + ", type=" + this.getType() + ", volumeSettingId=" + this.getVolumeSettingId() + ", awsCredentialsId=" + this.getAwsCredentialsId() + ", storagePrice=" + this.getStoragePrice() + ")";
    }
}

