/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.dataintell.visionapi.archiwareScanner.Job;
import io.dataintell.visionapi.domain.ArchiwareJob;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ArchiwareJob
implements Serializable {
    private Long id;
    private Date startTime;
    private Date endTime;
    private String status;
    private String result;

    public ArchiwareJob(Job job) {
        this.id = Long.valueOf(job.getId());
        this.startTime = this.formatLocalDateTime(job.getStartDate(), job.getStartTime());
        this.endTime = this.formatLocalDateTime(job.getEndDate(), job.getEndTime());
        this.status = job.getStatus();
        this.result = job.getResult();
    }

    private Date formatLocalDateTime(String date, String time) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyyHH:mm:ss");
        LocalDateTime localDateTime = LocalDateTime.parse(date.concat(time), formatter);
        ZonedDateTime zoneDateTime = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zoneDateTime.toInstant());
    }

    public String toString() {
        return "ArchiwareJob{id=" + this.id + ", starttime=" + this.startTime + ", endtime=" + this.endTime + ", status='" + this.status + "', result='" + this.result + "'}";
    }

    public static ArchiwareJobBuilder builder() {
        return new ArchiwareJobBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getStatus() {
        return this.status;
    }

    public String getResult() {
        return this.result;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchiwareJob)) {
            return false;
        }
        ArchiwareJob other = (ArchiwareJob)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArchiwareJob;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public ArchiwareJob() {
    }

    public ArchiwareJob(Long id, Date startTime, Date endTime, String status, String result) {
        this.id = id;
        this.startTime = startTime;
        this.endTime = endTime;
        this.status = status;
        this.result = result;
    }
}

