/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.dataintell.visionapi.domain.ArchiwareFile;
import io.dataintell.visionapi.domain.Link;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import javax.persistence.Embedded;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ArchiwareFile
implements Serializable {
    private String name;
    private String type;
    private Long size;
    private Long btime;
    private Long ctime;
    private Long mtime;
    private String path;
    @Embedded
    private List<Link> links;

    public String toString() {
        return "ArchiwareFile{name='" + this.name + "', type='" + this.type + "', size=" + this.size + ", btime=" + this.btime + ", ctime=" + this.ctime + ", mtime=" + this.mtime + ", path='" + this.path + "', links=" + this.links + "}";
    }

    public String getValidPath() {
        String linkPath = ((Link)this.links.get(0)).getHref();
        String validPath = linkPath.substring(linkPath.indexOf("/inventory") + 10);
        if (!validPath.endsWith(this.name)) {
            Path parentPath = Path.of(validPath, new String[0]).getParent();
            Path fixedPath = Path.of(parentPath.toString(), this.name);
            return fixedPath.toString();
        }
        return validPath;
    }

    public static ArchiwareFileBuilder builder() {
        return new ArchiwareFileBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Long getSize() {
        return this.size;
    }

    public Long getBtime() {
        return this.btime;
    }

    public Long getCtime() {
        return this.ctime;
    }

    public Long getMtime() {
        return this.mtime;
    }

    public String getPath() {
        return this.path;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public void setBtime(Long btime) {
        this.btime = btime;
    }

    public void setCtime(Long ctime) {
        this.ctime = ctime;
    }

    public void setMtime(Long mtime) {
        this.mtime = mtime;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchiwareFile)) {
            return false;
        }
        ArchiwareFile other = (ArchiwareFile)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$size = this.getSize();
        Long other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        Long this$btime = this.getBtime();
        Long other$btime = other.getBtime();
        if (this$btime == null ? other$btime != null : !((Object)this$btime).equals(other$btime)) {
            return false;
        }
        Long this$ctime = this.getCtime();
        Long other$ctime = other.getCtime();
        if (this$ctime == null ? other$ctime != null : !((Object)this$ctime).equals(other$ctime)) {
            return false;
        }
        Long this$mtime = this.getMtime();
        Long other$mtime = other.getMtime();
        if (this$mtime == null ? other$mtime != null : !((Object)this$mtime).equals(other$mtime)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        List this$links = this.getLinks();
        List other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArchiwareFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        Long $btime = this.getBtime();
        result = result * 59 + ($btime == null ? 43 : ((Object)$btime).hashCode());
        Long $ctime = this.getCtime();
        result = result * 59 + ($ctime == null ? 43 : ((Object)$ctime).hashCode());
        Long $mtime = this.getMtime();
        result = result * 59 + ($mtime == null ? 43 : ((Object)$mtime).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        List $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    public ArchiwareFile() {
    }

    public ArchiwareFile(String name, String type, Long size, Long btime, Long ctime, Long mtime, String path, List<Link> links) {
        this.name = name;
        this.type = type;
        this.size = size;
        this.btime = btime;
        this.ctime = ctime;
        this.mtime = mtime;
        this.path = path;
        this.links = links;
    }
}

