/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.domain.PeriodType;
import io.dataintell.visionapi.domain.VariationGeneric;
import io.dataintell.visionapi.domain.Volume;
import io.dataintell.visionapi.entity.VolumeSetting;
import io.dataintell.visionapi.service.VolumeService;
import io.dataintell.visionapi.service.VolumeSettingService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import javax.validation.Valid;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Volumes", description="Everything related to indexed volumes data and settings")
public class VolumeController {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    private final VolumeService volumeService;
    private final VolumeSettingService volumeSettingService;

    public VolumeController(VolumeService volumeService, VolumeSettingService volumeSettingService) {
        this.volumeService = volumeService;
        this.volumeSettingService = volumeSettingService;
    }

    @Deprecated
    @GetMapping(value={"/detailedVolumes/latestVersions"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get most recent value of indexed volumes")
    public PaginatedResult<Volume> getVolumes(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="name") String sort, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) throws IOException {
        return this.volumeService.getVolumes(page, size, sort, indexingDate);
    }

    @GetMapping(value={"v1/volumes"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get most recent value of indexed volumes based on an indexing dates")
    public PaginatedResult<Volume> getMostRecentVolumes(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="name") String sort, @RequestParam(value="direction", defaultValue="asc") String direction, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) throws IOException {
        return this.volumeService.getMostRecentVolumes(page, size, sort, direction, indexingDate);
    }

    @GetMapping(value={"/detailedVolumes"})
    @Operation(summary="Get all indexed volumes in one day", description="The result return the indexed volumes based on the number of scan done during a day")
    public PaginatedResult<Volume> getVolumesPerDay(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="name") String sort, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) throws IOException {
        return this.volumeService.getVolumesPerDay(page, size, sort, indexingDate);
    }

    @GetMapping(value={"v1/detailedVolumes/{id}"})
    @Operation(summary="Get volume by id")
    public PaginatedResult<Volume> getVolumeById(@PathVariable(value="id") long id, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="size", defaultValue="10") int size, @RequestParam(value="sort", defaultValue="indexingDate") String sortField, @RequestParam(value="direction", defaultValue="DESC") String direction, @RequestParam(value="from") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate from, @RequestParam(value="to") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate to) {
        return this.volumeService.getVolumeById(page, size, sortField, direction, id, from, to);
    }

    @GetMapping(value={"/detailedVolumes/biggestVariations"})
    @Operation(summary="Get indexed volumes with the biggest variation of size based on duration in days")
    public List<VariationGeneric<Volume, Long>> getBiggestVariations(@RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="type", defaultValue="days") String type, @RequestParam(value="duration", defaultValue="30") Integer duration) throws IOException {
        PeriodType periodType = PeriodType.fromValue((String)type);
        return this.volumeService.getBiggestVariations(indexingDate, size, periodType, duration);
    }

    @GetMapping(value={"/volumeSettings"})
    @Operation(summary="Get all", description="Get a collection of Volume Settings")
    public PaginatedResult<VolumeSetting> getVolumeSettings(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="name") String sort, @RequestParam(value="filterType", required=false) List<String> types) {
        return this.volumeSettingService.getVolumeSettings(page, size, sort, types);
    }

    @PostMapping(value={"/volumeSettings"})
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Create", description="Create a Volume Setting")
    public ResponseEntity<?> createVolumeSetting(@RequestBody @Valid VolumeSetting volumeSetting) {
        try {
            this.volumeSettingService.createVolumeSetting(volumeSetting);
            return ResponseEntity.status((int)201).build();
        }
        catch (DataIntegrityViolationException e) {
            return ResponseEntity.status((int)409).body((Object)"The name parameter should be unique, the name and the path should be less than 255 characters");
        }
        catch (Exception e) {
            return ResponseEntity.status((int)400).body((Object)"An error occur while creating the volume setting");
        }
    }

    @PutMapping(value={"/volumeSettings/{id}"})
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Update", description="Update Volume Setting property")
    public ResponseEntity<?> updateVolumeSetting(@PathVariable(value="id") Long id, @RequestBody @Valid VolumeSetting volumeSetting) {
        try {
            this.volumeSettingService.updateVolumeSetting(id, volumeSetting);
            return ResponseEntity.status((int)200).build();
        }
        catch (DataIntegrityViolationException e) {
            return ResponseEntity.status((int)409).body((Object)"The name parameter should be unique, the name and the path should be less than 255 characters");
        }
        catch (Exception e) {
            return ResponseEntity.status((int)400).body((Object)"An error occur while creating the volume setting");
        }
    }

    @DeleteMapping(value={"/volumeSettings/{id}"})
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Delete by id", description="Remove a Volume Setting")
    public void deleteVolumeSetting(@PathVariable(value="id") Long id) {
        this.volumeSettingService.deleteVolumeSetting(id);
    }
}

