/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.domain.ResetPasswordRequestByUser;
import io.dataintell.visionapi.domain.User;
import io.dataintell.visionapi.service.UserService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Profiles", description="Everything related to user profile management.")
public class UserProfileController {
    private final UserService userService;

    public UserProfileController(UserService userService) {
        this.userService = userService;
    }

    @PutMapping(value={"/v1/profiles"})
    @Operation(summary="Update profile", description="Update  current user profile")
    @ResponseStatus(value=HttpStatus.OK)
    public User updateProfile(@RequestBody @Valid User user) {
        return this.userService.updateProfile(user);
    }

    @PutMapping(value={"/v1/profiles/password"})
    @Operation(summary="Reset password", description="Reset current password")
    @ResponseStatus(value=HttpStatus.OK)
    public void resetPassword(@RequestBody @Valid ResetPasswordRequestByUser resetPasswordRequestByUser) {
        this.userService.resetPasswordByUser(resetPasswordRequestByUser);
    }
}

