/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.domain.ResetPasswordRequest;
import io.dataintell.visionapi.domain.User;
import io.dataintell.visionapi.domain.UserCreation;
import io.dataintell.visionapi.service.UserService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@PreAuthorize(value="hasRole('ROLE_ADMIN')")
@Tag(name="Users", description="Everything related to user management.")
public class UserController {
    private final UserService userService;

    public UserController(UserService userService) {
        this.userService = userService;
    }

    @GetMapping(value={"/v1/users"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all users", description="Returns all the users of your installation")
    public PaginatedResult<User> getUsers_v1(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="name") String sort) {
        return this.userService.getUsers_v1(page, size, sort);
    }

    @GetMapping(value={"/v1/users/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get user by Id", description="Return a specific user by Id")
    public User getUserById_v1(@PathVariable(value="id") Long id) {
        return this.userService.getUserById_v1(id.longValue());
    }

    @PostMapping(value={"/v1/users"})
    @Operation(summary="Create user", description="Create a new user")
    @ResponseStatus(value=HttpStatus.CREATED)
    public User createUser_v1(@Valid @RequestBody UserCreation user) {
        return this.userService.createUser_v1(user);
    }

    @PutMapping(value={"/v1/users/{id}"})
    @Operation(summary="Update user", description="Update a user by Id")
    @ResponseStatus(value=HttpStatus.OK)
    public User updateUser_v1(@PathVariable(value="id") Long id, @RequestBody @Valid User user) {
        return this.userService.updateUser_v1(id, user);
    }

    @PutMapping(value={"/v1/users/{userId}/roles/{roleId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Add role", description="Add a role by Id to a user by Id")
    public User addRole(@PathVariable Long userId, @PathVariable Long roleId) {
        return this.userService.addRole(userId, roleId);
    }

    @DeleteMapping(value={"/v1/users/{userId}/roles/{roleId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Remove role", description="Remove a role by Id from a user by Id")
    public User removeRole(@PathVariable Long userId, @PathVariable Long roleId) {
        return this.userService.removeRole(userId, roleId);
    }

    @PutMapping(value={"/v1/users/{id}/password"})
    @Operation(summary="Reset password", description="Reset the password of a user by Id")
    @ResponseStatus(value=HttpStatus.OK)
    public void resetPassword(@PathVariable(value="id") Long userId, @RequestBody @Valid ResetPasswordRequest resetPasswordRequest) {
        this.userService.resetPassword(userId, resetPasswordRequest);
    }

    @DeleteMapping(value={"/users/{id}"})
    @Operation(summary="Delete user", description="Delete a user by Id")
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteUser(@PathVariable(value="id") Long id) {
        this.userService.deleteUser(id);
    }
}

