/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.domain.StoragePrice;
import io.dataintell.visionapi.service.StoragePriceService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Storage Prices", description="Set custom pricing to monitor the cost of your Projects")
public class StoragePriceController {
    private final StoragePriceService service;

    public StoragePriceController(StoragePriceService service) {
        this.service = service;
    }

    @GetMapping(value={"v1/storage-prices/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get storage price by id")
    public StoragePrice get(@PathVariable(value="id") int id) {
        return this.service.findById(id);
    }

    @GetMapping(value={"v1/storage-prices"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all storage price")
    public List<StoragePrice> getAll() {
        return this.service.findAll();
    }

    @PostMapping(value={"v1/storage-prices"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Create storage price")
    public StoragePrice create(@RequestBody @Valid StoragePrice storagePrice) {
        return this.service.create(storagePrice);
    }

    @PutMapping(value={"v1/storage-prices/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Update storage price")
    public StoragePrice update(@PathVariable(value="id") int id, @RequestBody @Valid StoragePrice storagePrice) {
        return this.service.update(id, storagePrice);
    }

    @DeleteMapping(value={"v1/storage-prices/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Delete storage price by id")
    public void delete(@PathVariable(value="id") int id) {
        this.service.delete(id);
    }
}

