/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.domain.PeriodType;
import io.dataintell.visionapi.domain.Statistic;
import io.dataintell.visionapi.service.StatisticService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Statistics", description="Quickly get stats like duplicates, paths, and last accesses over your data")
@RequestMapping(value={"/statistics"})
public class StatisticController {
    private final StatisticService statisticService;

    public StatisticController(StatisticService statisticService) {
        this.statisticService = statisticService;
    }

    @GetMapping(value={"/lastAccess/{date}"})
    public Statistic getByLastAccess(@PathVariable(value="date") @DateTimeFormat(pattern="yyyy-MM-dd") Date date, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) throws IOException {
        return this.statisticService.getByLastAccess(date, indexingDate);
    }

    @GetMapping(value={"/duplicates/{indexingDate}"})
    public Statistic getDuplicatesStatistic(@PathVariable(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) throws IOException {
        return this.statisticService.getDuplicatesStatistic(indexingDate);
    }

    @GetMapping(value={"/duplicates"})
    public List<Statistic> getDuplicatesStatistics(@RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate, @RequestParam(value="numberOfDays", defaultValue="30") Integer numberOfDays) throws IOException {
        return this.statisticService.getDuplicatesStatistics(indexingDate, numberOfDays);
    }

    @GetMapping(value={"/paths"})
    public List<Statistic> getByPathList(@RequestParam(value="path") List<String> paths, @RequestParam(value="onlyDuplicate", defaultValue="false") Boolean onlyDuplicate, @RequestParam(value="lastAccess", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") Date lastAccess, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.statisticService.getByPathList(paths, onlyDuplicate, lastAccess, indexingDate);
    }

    @GetMapping(value={"/lastAccess"})
    public List<Statistic> getFilesNotUsedInPreviousPeriod(@RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate, @RequestParam(value="type", defaultValue="days") String type, @RequestParam(value="duration", defaultValue="30") Integer duration, @RequestParam(value="size", defaultValue="30") Integer size) throws IOException {
        PeriodType periodType = PeriodType.fromValue((String)type);
        return this.statisticService.getFilesNotUsedInPreviousPeriod(indexingDate, periodType, duration, size);
    }
}

