/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.entity.Server;
import io.dataintell.visionapi.service.ServerService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Servers", description="Manage the physical servers where data reside")
@RequestMapping(value={"/servers"})
public class ServerController {
    private final ServerService serverService;

    public ServerController(ServerService serverService) {
        this.serverService = serverService;
    }

    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all servers")
    public List<Server> getServers() {
        return this.serverService.getAllServers();
    }

    @GetMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get Server by Id")
    public Server getServerById(@PathVariable(value="id") Long id) {
        return this.serverService.getServerById(id.longValue());
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create Server")
    public Server createServer(@Valid @RequestBody Server server) {
        return this.serverService.createServer(server);
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="Update Server")
    @ResponseStatus(value=HttpStatus.OK)
    public Server updateServer(@PathVariable(value="id") Long id, @Valid @RequestBody Server server) {
        return this.serverService.updateServer(id, server);
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Delete Server")
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteServer(@PathVariable(value="id") Long id) {
        this.serverService.deleteServer(id);
    }
}

