/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.domain.Direction;
import io.dataintell.visionapi.domain.File;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.domain.ScrollResult;
import io.dataintell.visionapi.domain.search.SearchFilter;
import io.dataintell.visionapi.service.SearchService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDate;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Search", description="Search for files and folders")
@RequestMapping(value={"/v1/search"})
public class SearchController {
    private final SearchService searchService;

    public SearchController(SearchService searchService) {
        this.searchService = searchService;
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Search for files and folders with filters", description="For simple search just send an empty [] array in the body of the request with a valid indexingDate (2022-01-01). There is a limit of the first 10 000 results. If you want to go through a bigger list of results, use the deep pagination endpoint. When sending a list of Search Filters, the result will match any of the Search Filter object.")
    public PaginatedResult<File> search(@RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="size") String sort, @RequestParam(value="direction", defaultValue="ASC") Direction direction, @RequestBody List<SearchFilter> searchFilters) {
        return this.searchService.search(indexingDate, page, size, sort, direction, searchFilters);
    }

    @PostMapping(value={"/scroll"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Search for files and folders with filters for deep pagination", description="This endpoint is perfect for a scripting solution. For simple search just send an empty [] array in the body of the request with a valid indexingDate (2022-01-01). The subsequent calls to get other pages must be done in less than 5 minutes. The first request will define how all the subsequent requests will be done. For the initial call, the indexing date and at least an empty Search filter are mandatory. For the subsequent requests, only the scrollId is needed to loop through all the results. If a scrollId is present in the request, all other parameters will be ignored. When sending a list of Search Filters, the result will match any of the Search Filter object.")
    public ScrollResult<File> searchWithDeepPagination(@RequestParam(value="indexingDate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate, @RequestParam(value="scrollId", required=false) String scrollId, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="size") String sort, @RequestParam(value="direction", defaultValue="ASC") Direction direction, @RequestBody List<SearchFilter> searchFilters) {
        return this.searchService.searchWithDeepPagination(indexingDate, scrollId, size, sort, direction, searchFilters);
    }
}

