/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.domain.ApiResponse;
import io.dataintell.visionapi.domain.File;
import io.dataintell.visionapi.domain.Job;
import io.dataintell.visionapi.scanner.JobService;
import io.dataintell.visionapi.service.ScanService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;

@RestController
@Tag(name="Scans", description="Launch a local scan or schedule a remote scan to be executed by remote scanners")
@PreAuthorize(value="hasRole('ROLE_ADMIN')")
public class ScanController {
    private static final Logger logger = LoggerFactory.getLogger(ScanController.class);
    private final ScanService scanService;
    private final JobService jobService;

    public ScanController(ScanService scanService, JobService jobService) {
        this.scanService = scanService;
        this.jobService = jobService;
    }

    @Deprecated
    @PostMapping(value={"/scans/volumes/{id}"})
    public ResponseEntity<ApiResponse> scanVolume(@PathVariable(value="id") Long id, @RequestParam(value="cloneIndex", defaultValue="true") Boolean cloneIndex) {
        try {
            this.scanService.scanVolume(id, cloneIndex, LocalDate.now());
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)new ApiResponse(Boolean.valueOf(true), String.format("Volume with id [%s] was scanned", id)));
        }
        catch (NotFoundException e) {
            String message = String.format("Unable to find volume with id [%s]", id);
            logger.error(message, (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)new ApiResponse(Boolean.valueOf(false), message));
        }
        catch (HttpClientErrorException e) {
            String message = "Server is busy scanning other volumes, try again later";
            logger.error(message, (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body((Object)new ApiResponse(Boolean.valueOf(false), message));
        }
        catch (Exception e) {
            String message = String.format("An error occur while trying to scan volume with id [%s]", id);
            logger.error(message, (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new ApiResponse(Boolean.valueOf(false), message));
        }
    }

    @Deprecated
    @PostMapping(value={"/scans"})
    public ResponseEntity<ApiResponse> scanAll(@RequestParam(value="cloneIndex", defaultValue="true") Boolean cloneIndex) {
        try {
            this.scanService.scanAll(cloneIndex, LocalDate.now());
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)new ApiResponse(Boolean.valueOf(true), "All volumes were scanned"));
        }
        catch (NotFoundException e) {
            String message = "The server is not configured correctly";
            logger.error(message, (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)new ApiResponse(Boolean.valueOf(false), message));
        }
        catch (HttpClientErrorException e) {
            String message = "One of the servers is busy scanning other volumes, try again later";
            logger.error(message, (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body((Object)new ApiResponse(Boolean.valueOf(false), message));
        }
        catch (Exception e) {
            String message = "An error occur while trying to scan all volumes";
            logger.error(message, (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new ApiResponse(Boolean.valueOf(false), message));
        }
    }

    @PostMapping(value={"v1/scans/buckets"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Scan all buckets")
    public Job<?> scanAllBuckets(@RequestParam(value="cloneIndex", defaultValue="true") Boolean cloneIndex) {
        return this.jobService.dispatchScanAllBuckets(cloneIndex.booleanValue());
    }

    @PostMapping(value={"v1/scans/buckets/{id}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Scan a bucket with his id")
    public Job<?> scanBucketById(@PathVariable(value="id") Integer id, @RequestParam(value="cloneIndex", defaultValue="true") Boolean cloneIndex) {
        return this.jobService.dispatchScanBuckets(Collections.singletonList(id), cloneIndex.booleanValue());
    }

    @PostMapping(value={"v1/scans/archiwares"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Scan all archiwares")
    public Job<?> scanAllArchiwares(@RequestParam(value="cloneIndex", defaultValue="true") Boolean cloneIndex) {
        return this.jobService.dispatchScanAllArchiwares(cloneIndex.booleanValue());
    }

    @PostMapping(value={"v1/scans/archiwares/{id}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Scan a archiware with his id")
    public Job<?> scanArchiwareById(@PathVariable(value="id") Long id, @RequestParam(value="cloneIndex", defaultValue="true") Boolean cloneIndex) {
        return this.jobService.dispatchScanArchiwares(Collections.singletonList(id), cloneIndex.booleanValue());
    }

    @PostMapping(value={"/v1/scans/volumes/{id}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create a scan-by-volume-id job for remote Scanners")
    public Job<?> scanVolumeV1(@PathVariable(value="id") long id, @RequestParam(value="cloneIndex", defaultValue="true") boolean cloneIndex) {
        return this.jobService.dispatchScanVolume(id, cloneIndex);
    }

    @PostMapping(value={"/v1/scans/servers/{id}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create a scan-by-server-id job for remote Scanners")
    public Job<?> scanServer(@PathVariable(value="id") Long id, @RequestParam(value="cloneIndex", defaultValue="true") Boolean cloneIndex) {
        return this.jobService.dispatchScanServer(id.longValue(), cloneIndex.booleanValue());
    }

    @PostMapping(value={"/v1/scans/servers"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create a scan-by-server-id job for remote Scanners")
    public List<Job<?>> scanAllServers(@RequestParam(value="cloneIndex", defaultValue="true") Boolean cloneIndex) {
        return this.jobService.dispatchScanAll(cloneIndex.booleanValue());
    }

    @PostMapping(value={"/scans/duplicates"})
    public ResponseEntity<ApiResponse> tagDuplicates(@RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        try {
            LocalDate date = indexingDate != null ? indexingDate : LocalDate.now();
            this.scanService.postScanJob(date);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)new ApiResponse(Boolean.valueOf(true), "All duplicated files/folders were tagged"));
        }
        catch (HttpClientErrorException e) {
            String message = "One of the servers is busy scanning other volumes, try again later";
            logger.error(message, (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body((Object)new ApiResponse(Boolean.valueOf(false), message));
        }
        catch (Exception e) {
            String message = "An error occur while trying to tag duplicate files/folders";
            logger.error(message, (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new ApiResponse(Boolean.valueOf(false), message));
        }
    }

    @PostMapping(value={"/v1/scans/files"})
    @Operation(summary="Add files", description="Add a list of files")
    @ResponseStatus(value=HttpStatus.OK)
    public void addFiles(@RequestParam(value="indexingDate") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate indexingDate, @RequestBody List<File> files) {
        this.scanService.indexListOfFiles(files, indexingDate);
    }
}

