/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.domain.Role;
import io.dataintell.visionapi.service.RoleService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Roles", description="Everything related to role management")
public class RoleController {
    private final RoleService service;

    public RoleController(RoleService service) {
        this.service = service;
    }

    @PostMapping(value={"v1/roles"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create role", description="Create a new role")
    public Role create(@RequestBody @Valid Role role) {
        return this.service.create(role);
    }

    @GetMapping(value={"v1/roles"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all roles", description="Returns all the roles of your installation")
    public PaginatedResult<Role> getAll(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="name") String sort, @RequestParam(value="direction", defaultValue="asc") String direction) {
        return this.service.getAll(page, size, sort, direction);
    }

    @GetMapping(value={"v1/roles/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get role by Id", description="Return a specific role by Id")
    public Role get(@PathVariable Long id) {
        return this.service.get(id);
    }

    @PutMapping(value={"v1/roles/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update role", description="Update a role by Id")
    public Role update(@PathVariable Long id, @RequestBody @Valid Role role) {
        return this.service.update(id, role);
    }

    @DeleteMapping(value={"v1/roles/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete role", description="Delete a role by Id")
    public void delete(@PathVariable Long id) {
        this.service.delete(id);
    }
}

