/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.domain.ApiResponse;
import io.dataintell.visionapi.domain.DetailedProject;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.domain.PeriodType;
import io.dataintell.visionapi.entity.Project;
import io.dataintell.visionapi.service.ProjectService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.List;
import javassist.NotFoundException;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Projects", description="Create projects to gain visibility over an aggregate of Volumes and Paths")
public class ProjectController {
    private static final Logger logger = LoggerFactory.getLogger(ProjectController.class);
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    private final ProjectService projectService;

    public ProjectController(ProjectService projectService) {
        this.projectService = projectService;
    }

    @GetMapping(value={"/projects/details"})
    @Operation(summary="Get all projects")
    public ResponseEntity<?> getProjects(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="name") String sort, @RequestParam(value="direction", defaultValue="asc") String direction, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate, @RequestParam(value="filter", defaultValue="", required=false) String filter) {
        try {
            PaginatedResult detailedProjectPaginatedResult = this.projectService.getDetailedProjects(page, size, sort, direction, indexingDate, filter);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)detailedProjectPaginatedResult);
        }
        catch (Exception e) {
            String message = "An error occur while fetching the list of detailed projects";
            logger.error(message, (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new ApiResponse(Boolean.valueOf(false), message));
        }
    }

    @GetMapping(value={"/projects/details/{id}"})
    @Operation(summary="Get project details by id")
    public DetailedProject getDetailedProjectById(@PathVariable(value="id") Long id, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.projectService.getDetailedProjectById(id.longValue(), indexingDate);
    }

    @GetMapping(value={"v1/projects/details/{id}/history"})
    @Operation(summary="Get project history by id")
    public List<DetailedProject> getDetailedProjectHistoryById(@PathVariable(value="id") long id, @RequestParam(value="size", defaultValue="20") int size, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.projectService.getDetailedProjectHistoryById(Long.valueOf(id), Integer.valueOf(size), indexingDate);
    }

    @GetMapping(value={"/projects/details/{id}/reports"})
    @Operation(summary="Get project report by id")
    public ResponseEntity<?> getReportforProject(@PathVariable(value="id") Long id, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        try {
            File file = this.projectService.getReportForProject(id, indexingDate);
            Path path = Paths.get(file.getAbsolutePath(), new String[0]);
            ByteArrayResource resource = new ByteArrayResource(Files.readAllBytes(path));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", String.format("attachment; filename=%s", file.getName()));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(headers)).contentLength(file.length()).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)resource);
        }
        catch (NotFoundException e) {
            logger.debug(e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)new ApiResponse(Boolean.valueOf(false), e.getMessage()));
        }
        catch (Exception e) {
            String message = String.format("An error occur while creating the report for the detailed project with id [%s] and indexing date [%s]", id, indexingDate);
            logger.error(message, (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new ApiResponse(Boolean.valueOf(false), message));
        }
    }

    @GetMapping(value={"/projects/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get project by id")
    public Project getProject(@PathVariable(value="id") Long id) {
        return this.projectService.getProjectById(id);
    }

    @GetMapping(value={"/projects"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all projects")
    public PaginatedResult<Project> getProjects(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="name") String sort, @RequestParam(value="direction", defaultValue="asc") String direction) {
        return this.projectService.getAll(page, size, sort, direction);
    }

    @PostMapping(value={"/projects"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasAnyRole('ROLE_ADMIN', 'ROLE_PROJECT_MANAGER')")
    @Operation(summary="Create new project", description="It will also creates a new detailedProject")
    public Project createProject(@RequestBody @Valid Project project) {
        return this.projectService.createProject(project);
    }

    @PutMapping(value={"/projects"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAnyRole('ROLE_ADMIN', 'ROLE_PROJECT_MANAGER')")
    @Operation(summary="Update project", description="It will also update the detailedProject in relation")
    public Project updateProject(@RequestBody @Valid Project project) {
        return this.projectService.updateProject(project);
    }

    @DeleteMapping(value={"/projects/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAnyRole('ROLE_ADMIN', 'ROLE_PROJECT_MANAGER')")
    @Operation(summary="Delete project by id", description="It will also deletes the detailedProject in relation from ES")
    public void deleteProject(@PathVariable(value="id") Long id, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        this.projectService.deleteProject(id, indexingDate);
    }

    @GetMapping(value={"/projects/mostActiveProjects"})
    @Operation(summary="Get most active project")
    public ResponseEntity<?> getMostActiveProject(@RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="type", defaultValue="days") String type, @RequestParam(value="duration", defaultValue="30") Integer duration) {
        try {
            PeriodType periodType = PeriodType.fromValue((String)type);
            List mostActiveProject = this.projectService.getMostActiveProject(indexingDate, size, periodType, duration);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)mostActiveProject);
        }
        catch (Exception e) {
            String message = "Unable to get most active project";
            logger.error(message, (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new ApiResponse(Boolean.valueOf(false), message));
        }
    }
}

