/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.domain.DateHistogram;
import io.dataintell.visionapi.domain.DateIntervalType;
import io.dataintell.visionapi.domain.FieldCountSize;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.file.FileService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Files", description="Everything related to indexed file metadata")
public class FileController {
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    private final FileService fileService;

    public FileController(FileService fileService) {
        this.fileService = fileService;
    }

    @GetMapping(value={"/files/search"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Search for file with filters")
    public PaginatedResult<io.dataintell.visionapi.domain.File> searchFiles(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="onlyDuplicates", required=false) Boolean onlyDuplicates, @RequestParam(value="volumeId", required=false) List<Long> volumeIds, @RequestParam(value="startingPath", required=false) String startingPath, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="group", required=false) String group, @RequestParam(value="lastAccessAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessAfter, @RequestParam(value="lastAccessBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessBefore, @RequestParam(value="lastModifiedAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedAfter, @RequestParam(value="lastModifiedBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedBefore, @RequestParam(value="creationAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationAfter, @RequestParam(value="creationBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationBefore, @RequestParam(value="extension", required=false) List<String> extensions, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="size") String sort, @RequestParam(value="minimumSize", required=false) Long minimumSize, @RequestParam(value="maximumSize", required=false) Long maximumSize, @RequestParam(value="showOnlyDeletedFiles", required=false) Boolean showOnlyDeletedFiles, @RequestParam(value="volumeAndPath", required=false) List<String> volumesAndPaths, @RequestParam(value="ignorePattern", required=false) List<String> ignorePatterns, @RequestParam(value="tag", required=false) List<String> tags, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.fileService.searchFiles(search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, page, size, sort, minimumSize, maximumSize, volumesAndPaths, ignorePatterns, tags, showOnlyDeletedFiles, Boolean.valueOf(false), null, null, null, null, indexingDate);
    }

    @PostMapping(value={"/v1/files/search/tags"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Add a tag by search query")
    public void addTagForSearch(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="onlyDuplicates", required=false) Boolean onlyDuplicates, @RequestParam(value="volumeId", required=false) List<Long> volumeIds, @RequestParam(value="startingPath", required=false) String startingPath, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="group", required=false) String group, @RequestParam(value="lastAccessAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessAfter, @RequestParam(value="lastAccessBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessBefore, @RequestParam(value="lastModifiedAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedAfter, @RequestParam(value="lastModifiedBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedBefore, @RequestParam(value="creationAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationAfter, @RequestParam(value="creationBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationBefore, @RequestParam(value="extension", required=false) List<String> extensions, @RequestParam(value="minimumSize", required=false) Long minimumSize, @RequestParam(value="maximumSize", required=false) Long maximumSize, @RequestParam(value="showOnlyDeletedFiles", required=false) Boolean showOnlyDeletedFiles, @RequestParam(value="volumeAndPath", required=false) List<String> volumesAndPaths, @RequestParam(value="ignorePattern", required=false) List<String> ignorePatterns, @RequestParam(value="tag", required=false) List<String> tags, @RequestParam(value="isDirectory") Boolean isDirectory, @RequestParam(value="minimumNumberOfFiles", required=false) Long minimumNumberOfFiles, @RequestParam(value="maximumNumberOfFiles", required=false) Long maximumNumberOfFiles, @RequestParam(value="minimumNumberOfFolders", required=false) Long minimumNumberOfFolders, @RequestParam(value="maximumNumberOfFolders", required=false) Long maximumNumberOfFolders, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate, @RequestParam(value="tag") String tag) {
        this.fileService.addTagForSearch(search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, minimumSize, maximumSize, volumesAndPaths, ignorePatterns, tags, showOnlyDeletedFiles, isDirectory, minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders, indexingDate, tag);
    }

    @GetMapping(value={"/files/search/dates"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get an histogram with count and size of files group by date", description="By default the histogram are group by month, but it could be YEAR, MONTH, WEEK, DAY")
    public List<DateHistogram> getDateHistogramBasedOnSearch(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="onlyDuplicates", required=false) Boolean onlyDuplicates, @RequestParam(value="volumeId", required=false) List<Long> volumeIds, @RequestParam(value="startingPath", required=false) String startingPath, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="group", required=false) String group, @RequestParam(value="lastAccessAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessAfter, @RequestParam(value="lastAccessBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessBefore, @RequestParam(value="lastModifiedAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedAfter, @RequestParam(value="lastModifiedBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedBefore, @RequestParam(value="creationAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationAfter, @RequestParam(value="creationBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationBefore, @RequestParam(value="extension", required=false) List<String> extensions, @RequestParam(value="dateField") String dateField, @RequestParam(value="minimumSize", required=false) Long minimumSize, @RequestParam(value="maximumSize", required=false) Long maximumSize, @RequestParam(value="showOnlyDeletedFiles", required=false) Boolean showOnlyDeletedFiles, @RequestParam(value="dateIntervalType", defaultValue="MONTH") DateIntervalType dateIntervalType, @RequestParam(value="size", defaultValue="12") Integer size, @RequestParam(value="volumeAndPath", required=false) List<String> volumesAndPaths, @RequestParam(value="ignorePattern", required=false) List<String> ignorePatterns, @RequestParam(value="tag", required=false) List<String> tags, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.fileService.getDateHistogramBasedOnSearch(search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, dateField, minimumSize, maximumSize, showOnlyDeletedFiles, dateIntervalType, size, volumesAndPaths, ignorePatterns, tags, Boolean.valueOf(false), null, null, null, null, indexingDate);
    }

    @GetMapping(value={"/files/search/fields"})
    @Operation(summary="Get an histogram with count and size of files group by a field", description="A field could be any file field like name, path, owner, group, extension, size, volumeId, etc. Look at File schema to get the full list of fields.")
    public List<FieldCountSize> getSumAndTotalOfAField(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="onlyDuplicates", required=false) Boolean onlyDuplicates, @RequestParam(value="volumeId", required=false) List<Long> volumeIds, @RequestParam(value="startingPath", required=false) String startingPath, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="group", required=false) String group, @RequestParam(value="lastAccessAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessAfter, @RequestParam(value="lastAccessBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessBefore, @RequestParam(value="lastModifiedAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedAfter, @RequestParam(value="lastModifiedBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedBefore, @RequestParam(value="creationAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationAfter, @RequestParam(value="creationBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationBefore, @RequestParam(value="extension", required=false) List<String> extensions, @RequestParam(value="fieldName") String fieldName, @RequestParam(value="minimumSize", required=false) Long minimumSize, @RequestParam(value="maximumSize", required=false) Long maximumSize, @RequestParam(value="showOnlyDeletedFiles", required=false) Boolean showOnlyDeletedFiles, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="volumeAndPath", required=false) List<String> volumesAndPaths, @RequestParam(value="ignorePattern", required=false) List<String> ignorePatterns, @RequestParam(value="tag", required=false) List<String> tags, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.fileService.getSumAndTotalOfAField(search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, fieldName, minimumSize, maximumSize, showOnlyDeletedFiles, size, volumesAndPaths, ignorePatterns, tags, Boolean.valueOf(false), null, null, null, null, indexingDate);
    }

    @GetMapping(value={"/files/search/sizes"})
    @Operation(summary="Get the total size of all the files based on a search request")
    public long getSizeOfSearchedFiles(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="onlyDuplicates", required=false) Boolean onlyDuplicates, @RequestParam(value="volumeId", required=false) List<Long> volumeIds, @RequestParam(value="startingPath", required=false) String startingPath, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="group", required=false) String group, @RequestParam(value="lastAccessAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessAfter, @RequestParam(value="lastAccessBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessBefore, @RequestParam(value="lastModifiedAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedAfter, @RequestParam(value="lastModifiedBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedBefore, @RequestParam(value="creationAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationAfter, @RequestParam(value="creationBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationBefore, @RequestParam(value="extension", required=false) List<String> extensions, @RequestParam(value="minimumSize", required=false) Long minimumSize, @RequestParam(value="maximumSize", required=false) Long maximumSize, @RequestParam(value="showOnlyDeletedFiles", required=false) Boolean showOnlyDeletedFiles, @RequestParam(value="volumeAndPath", required=false) List<String> volumesAndPaths, @RequestParam(value="ignorePattern", required=false) List<String> ignorePatterns, @RequestParam(value="tag", required=false) List<String> tags, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.fileService.getSizeOfSearchedFiles(search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, minimumSize, maximumSize, showOnlyDeletedFiles, volumesAndPaths, ignorePatterns, tags, Boolean.valueOf(false), null, null, null, null, indexingDate);
    }

    @GetMapping(value={"/files/search/csv"})
    @Operation(summary="Export a csv file with all the metadata based on a search request", description="The result will add more fields then the search endpoint like human readable size. There is a limit of 1 000 000 files")
    public ResponseEntity<Resource> searchFilesAsCSV(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="onlyDuplicates", required=false) Boolean onlyDuplicates, @RequestParam(value="volumeId", required=false) List<Long> volumeIds, @RequestParam(value="startingPath", required=false) String startingPath, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="group", required=false) String group, @RequestParam(value="lastAccessAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessAfter, @RequestParam(value="lastAccessBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessBefore, @RequestParam(value="lastModifiedAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedAfter, @RequestParam(value="lastModifiedBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedBefore, @RequestParam(value="creationAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationAfter, @RequestParam(value="creationBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationBefore, @RequestParam(value="extension", required=false) List<String> extensions, @RequestParam(value="sort", defaultValue="size") String sort, @RequestParam(value="minimumSize", required=false) Long minimumSize, @RequestParam(value="maximumSize", required=false) Long maximumSize, @RequestParam(value="showOnlyDeletedFiles", required=false) Boolean showOnlyDeletedFiles, @RequestParam(value="volumeAndPath", required=false) List<String> volumesAndPaths, @RequestParam(value="ignorePattern", required=false) List<String> ignorePatterns, @RequestParam(value="tag", required=false) List<String> tags, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        try {
            File file = this.fileService.createCsv(search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, extensions, sort, minimumSize, maximumSize, showOnlyDeletedFiles, volumesAndPaths, ignorePatterns, tags, Boolean.valueOf(false), null, null, null, null, indexingDate);
            Path path = Paths.get(file.getAbsolutePath(), new String[0]);
            ByteArrayResource resource = new ByteArrayResource(Files.readAllBytes(path));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", String.format("attachment; filename=%s", file.getName()));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(headers)).contentLength(file.length()).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)resource);
        }
        catch (IOException e) {
            log.error(String.format("Unable to create CSV for the following search %s, onlyDuplicate %s, volumeId %s, startingPath %s, owner %s, group %s, lastAccessAfter %s, lastAccessBefore %s, lastModifiedAfter %s, lastModifiedBefore %s, extension %s, sort %s, indexingDate %s", search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, extensions, sort, indexingDate), (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/files/search/folders/csv"})
    @Operation(summary="Export a csv file with all the metadata based on a search request for the folders", description="The result will add more fields then the search endpoint like human readable size. There is a limit of 1 000 000 files")
    public ResponseEntity<Resource> searchFoldersAsCSV(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="onlyDuplicates", required=false) Boolean onlyDuplicates, @RequestParam(value="volumeId", required=false) List<Long> volumeIds, @RequestParam(value="startingPath", required=false) String startingPath, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="group", required=false) String group, @RequestParam(value="lastAccessAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessAfter, @RequestParam(value="lastAccessBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessBefore, @RequestParam(value="lastModifiedAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedAfter, @RequestParam(value="lastModifiedBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedBefore, @RequestParam(value="creationAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationAfter, @RequestParam(value="creationBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationBefore, @RequestParam(value="sort", defaultValue="size") String sort, @RequestParam(value="minimumSize", required=false) Long minimumSize, @RequestParam(value="maximumSize", required=false) Long maximumSize, @RequestParam(value="showOnlyDeletedFiles", required=false) Boolean showOnlyDeletedFolders, @RequestParam(value="volumeAndPath", required=false) List<String> volumesAndPaths, @RequestParam(value="ignorePattern", required=false) List<String> ignorePatterns, @RequestParam(value="tag", required=false) List<String> tags, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        try {
            File file = this.fileService.createCsvOfFolders(search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, sort, minimumSize, maximumSize, showOnlyDeletedFolders, volumesAndPaths, ignorePatterns, tags, indexingDate);
            Path path = Paths.get(file.getAbsolutePath(), new String[0]);
            ByteArrayResource resource = new ByteArrayResource(Files.readAllBytes(path));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", String.format("attachment; filename=%s", file.getName()));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(headers)).contentLength(file.length()).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)resource);
        }
        catch (IOException e) {
            log.error(String.format("Unable to create CSV of folders for the following search %s, onlyDuplicate %s, volumeId %s, startingPath %s, owner %s, group %s, lastAccessAfter %s, lastAccessBefore %s, lastModifiedAfter %s, lastModifiedBefore %s, sort %s, indexingDate %s", search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, sort, indexingDate), (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/files/directory"})
    @Operation(summary="Get all the files in a directory", description="The list will be only the files that are directly in the directory.")
    public PaginatedResult<io.dataintell.visionapi.domain.File> getFilesOfDirectory(@RequestParam(value="directoryPath") String directoryPath, @RequestParam(value="volumeId", required=false) Long volumeId, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="size") String sort, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.fileService.getFilesOfDirectory(directoryPath, volumeId, page, size, sort, indexingDate);
    }

    @GetMapping(value={"/files/projects/{id}"})
    @Operation(summary="Get all the files of a project")
    public PaginatedResult<io.dataintell.visionapi.domain.File> getFilesByProject(@PathVariable(value="id") Long id, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="onlyDuplicate", defaultValue="false") Boolean onlyDuplicate, @RequestParam(value="onlyArchived", defaultValue="false") Boolean onlyArchived, @RequestParam(value="last_access") @DateTimeFormat(pattern="yyyy-MM-dd") Date date, @RequestParam(value="sort", defaultValue="size") String sort, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.fileService.getFilesByProject(id, page, size, onlyDuplicate, onlyArchived, date, sort, indexingDate);
    }

    @GetMapping(value={"/files/hash/{hash}"})
    @Operation(summary="Get all the files with a specific identification hash", description="Two files have the same identification hash when they have the same names, last modified dates and sizes.")
    public PaginatedResult<io.dataintell.visionapi.domain.File> getFilesByHash(@PathVariable(value="hash") String hash, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="name") String sort, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.fileService.getFilesByHash(hash, page, size, sort, indexingDate, false);
    }

    @PutMapping(value={"/files/{id}"})
    @Operation(summary="Update by Id", description="Change the values of a file by Id and Payload")
    @ResponseStatus(value=HttpStatus.OK)
    public void update(@PathVariable(value="id") String id, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate, @RequestBody io.dataintell.visionapi.domain.File file) {
        this.fileService.update(id, file, indexingDate);
    }

    @GetMapping(value={"/v1/files/tags"})
    @Operation(summary="Get all the tags", description="Get all the tags that are used by files")
    @ResponseStatus(value=HttpStatus.OK)
    public List<String> getTags(@RequestParam(value="size", defaultValue="1000") Integer size, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.fileService.getTags(size, indexingDate);
    }
}

