/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.domain.DateHistogram;
import io.dataintell.visionapi.domain.DateIntervalType;
import io.dataintell.visionapi.domain.FieldCountSize;
import io.dataintell.visionapi.domain.FileStatistics;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.file.FileService;
import io.dataintell.visionapi.service.DirectoryService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Directories", description="Everything related to indexed directories metadata. The directory schema is the same as the file.")
@RequestMapping(value={"/directories"})
public class DirectoryController {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryController.class);
    private final DirectoryService directoryService;
    private final FileService fileService;

    public DirectoryController(DirectoryService directoryService, FileService fileService) {
        this.directoryService = directoryService;
        this.fileService = fileService;
    }

    @GetMapping(value={""})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get directories with path", description="The default result is all the directories")
    public PaginatedResult<io.dataintell.visionapi.domain.File> getDirectories(@RequestParam(value="path", defaultValue="") String path, @RequestParam(value="volumeId", required=false) Long volumeId, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="name") String sort, @RequestParam(value="showHiddenDirectories", defaultValue="false") Boolean showHiddenDirectories, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.directoryService.getDirectories(path, volumeId, page, size, sort, showHiddenDirectories, indexingDate);
    }

    @GetMapping(value={"/names"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Search a directory with a name", description="The search result will give possible results and it's not a exact match with the name.")
    public PaginatedResult<io.dataintell.visionapi.domain.File> searchDirectoryByName(@RequestParam(value="name", defaultValue="") String name, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.directoryService.searchDirectoryByName(name, page, size, indexingDate);
    }

    @GetMapping(value={"/search"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Search a directory with filters")
    public PaginatedResult<io.dataintell.visionapi.domain.File> searchDirectories(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="onlyDuplicates", required=false) Boolean onlyDuplicates, @RequestParam(value="volumeId", required=false) List<Long> volumeIds, @RequestParam(value="startingPath", required=false) String startingPath, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="group", required=false) String group, @RequestParam(value="lastAccessAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessAfter, @RequestParam(value="lastAccessBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessBefore, @RequestParam(value="lastModifiedAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedAfter, @RequestParam(value="lastModifiedBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedBefore, @RequestParam(value="creationAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationAfter, @RequestParam(value="creationBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationBefore, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="size") String sort, @RequestParam(value="minimumSize", required=false) Long minimumSize, @RequestParam(value="maximumSize", required=false) Long maximumSize, @RequestParam(value="showOnlyDeletedFiles", required=false) Boolean showOnlyDeletedFiles, @RequestParam(value="volumeAndPath", required=false) List<String> volumesAndPaths, @RequestParam(value="ignorePattern", required=false) List<String> ignorePatterns, @RequestParam(value="tag", required=false) List<String> tags, @RequestParam(value="minimumNumberOfFiles", required=false) Long minimumNumberOfFiles, @RequestParam(value="maximumNumberOfFiles", required=false) Long maximumNumberOfFiles, @RequestParam(value="minimumNumberOfFolders", required=false) Long minimumNumberOfFolders, @RequestParam(value="maximumNumberOfFolders", required=false) Long maximumNumberOfFolders, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.fileService.searchFiles(search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, null, page, size, sort, minimumSize, maximumSize, volumesAndPaths, ignorePatterns, tags, showOnlyDeletedFiles, Boolean.valueOf(true), minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders, indexingDate);
    }

    @GetMapping(value={"/search/dates"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get an histogram with count and size of directories group by date", description="By default the histogram are group by month, but it could be YEAR, MONTH, WEEK, DAY")
    public List<DateHistogram> getDateHistogramBasedOnSearch(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="onlyDuplicates", required=false) Boolean onlyDuplicates, @RequestParam(value="volumeId", required=false) List<Long> volumeIds, @RequestParam(value="startingPath", required=false) String startingPath, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="group", required=false) String group, @RequestParam(value="lastAccessAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessAfter, @RequestParam(value="lastAccessBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessBefore, @RequestParam(value="lastModifiedAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedAfter, @RequestParam(value="lastModifiedBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedBefore, @RequestParam(value="creationAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationAfter, @RequestParam(value="creationBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationBefore, @RequestParam(value="dateField") String dateField, @RequestParam(value="minimumSize", required=false) Long minimumSize, @RequestParam(value="maximumSize", required=false) Long maximumSize, @RequestParam(value="showOnlyDeletedFiles", required=false) Boolean showOnlyDeletedFiles, @RequestParam(value="dateIntervalType", defaultValue="MONTH") DateIntervalType dateIntervalType, @RequestParam(value="size", defaultValue="12") Integer size, @RequestParam(value="volumeAndPath", required=false) List<String> volumesAndPaths, @RequestParam(value="ignorePattern", required=false) List<String> ignorePatterns, @RequestParam(value="tag", required=false) List<String> tags, @RequestParam(value="minimumNumberOfFiles", required=false) Long minimumNumberOfFiles, @RequestParam(value="maximumNumberOfFiles", required=false) Long maximumNumberOfFiles, @RequestParam(value="minimumNumberOfFolders", required=false) Long minimumNumberOfFolders, @RequestParam(value="maximumNumberOfFolders", required=false) Long maximumNumberOfFolders, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.fileService.getDateHistogramBasedOnSearch(search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, null, dateField, minimumSize, maximumSize, showOnlyDeletedFiles, dateIntervalType, size, volumesAndPaths, ignorePatterns, tags, Boolean.valueOf(true), minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders, indexingDate);
    }

    @GetMapping(value={"/search/fields"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get an histogram with count and size of directory group by a field", description="A field could be any file field like name, path, owner, group, extension, size, volumeId, etc. Look at File schema to get the full list of fields.")
    public List<FieldCountSize> getSumAndTotalOfAField(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="onlyDuplicates", required=false) Boolean onlyDuplicates, @RequestParam(value="volumeId", required=false) List<Long> volumeIds, @RequestParam(value="startingPath", required=false) String startingPath, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="group", required=false) String group, @RequestParam(value="lastAccessAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessAfter, @RequestParam(value="lastAccessBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessBefore, @RequestParam(value="lastModifiedAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedAfter, @RequestParam(value="lastModifiedBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedBefore, @RequestParam(value="creationAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationAfter, @RequestParam(value="creationBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationBefore, @RequestParam(value="fieldName") String fieldName, @RequestParam(value="minimumSize", required=false) Long minimumSize, @RequestParam(value="maximumSize", required=false) Long maximumSize, @RequestParam(value="showOnlyDeletedFiles", required=false) Boolean showOnlyDeletedFiles, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="volumeAndPath", required=false) List<String> volumesAndPaths, @RequestParam(value="ignorePattern", required=false) List<String> ignorePatterns, @RequestParam(value="tag", required=false) List<String> tags, @RequestParam(value="minimumNumberOfFiles", required=false) Long minimumNumberOfFiles, @RequestParam(value="maximumNumberOfFiles", required=false) Long maximumNumberOfFiles, @RequestParam(value="minimumNumberOfFolders", required=false) Long minimumNumberOfFolders, @RequestParam(value="maximumNumberOfFolders", required=false) Long maximumNumberOfFolders, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.fileService.getSumAndTotalOfAField(search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, null, fieldName, minimumSize, maximumSize, showOnlyDeletedFiles, size, volumesAndPaths, ignorePatterns, tags, Boolean.valueOf(true), minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders, indexingDate);
    }

    @GetMapping(value={"/search/csv"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Export a csv file with all the metadata based on a search request", description="The result will add more fields then the search endpoint like human readable size. There is a limit of 1 000 000 files")
    public ResponseEntity<Resource> searchFilesAsCSV(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="onlyDuplicates", required=false) Boolean onlyDuplicates, @RequestParam(value="volumeId", required=false) List<Long> volumeIds, @RequestParam(value="startingPath", required=false) String startingPath, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="group", required=false) String group, @RequestParam(value="lastAccessAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessAfter, @RequestParam(value="lastAccessBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastAccessBefore, @RequestParam(value="lastModifiedAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedAfter, @RequestParam(value="lastModifiedBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate lastModifiedBefore, @RequestParam(value="creationAfter", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationAfter, @RequestParam(value="creationBefore", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate creationBefore, @RequestParam(value="sort", defaultValue="size") String sort, @RequestParam(value="minimumSize", required=false) Long minimumSize, @RequestParam(value="maximumSize", required=false) Long maximumSize, @RequestParam(value="showOnlyDeletedFiles", required=false) Boolean showOnlyDeletedFiles, @RequestParam(value="volumeAndPath", required=false) List<String> volumesAndPaths, @RequestParam(value="ignorePattern", required=false) List<String> ignorePatterns, @RequestParam(value="tag", required=false) List<String> tags, @RequestParam(value="minimumNumberOfFiles", required=false) Long minimumNumberOfFiles, @RequestParam(value="maximumNumberOfFiles", required=false) Long maximumNumberOfFiles, @RequestParam(value="minimumNumberOfFolders", required=false) Long minimumNumberOfFolders, @RequestParam(value="maximumNumberOfFolders", required=false) Long maximumNumberOfFolders, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        try {
            File file = this.fileService.createCsv(search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, creationAfter, creationBefore, null, sort, minimumSize, maximumSize, showOnlyDeletedFiles, volumesAndPaths, ignorePatterns, tags, Boolean.valueOf(true), minimumNumberOfFiles, maximumNumberOfFiles, minimumNumberOfFolders, maximumNumberOfFolders, indexingDate);
            Path path = Paths.get(file.getAbsolutePath(), new String[0]);
            ByteArrayResource resource = new ByteArrayResource(Files.readAllBytes(path));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", String.format("attachment; filename=%s", file.getName()));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(headers)).contentLength(file.length()).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)resource);
        }
        catch (Exception e) {
            logger.error(String.format("Unable to create CSV for the following search %s, onlyDuplicate %s, volumeId %s, startingPath %s, owner %s, group %s, lastAccessAfter %s, lastAccessBefore %s, lastModifiedAfter %s, lastModifiedBefore %s, extension %s, sort %s, indexingDate %s", search, onlyDuplicates, volumeIds, startingPath, owner, group, lastAccessAfter, lastAccessBefore, lastModifiedAfter, lastModifiedBefore, null, sort, indexingDate), (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/details"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all the indexed data of a specific directory", description="By default, the result will give the same directory order by indexed date desc.")
    public PaginatedResult<io.dataintell.visionapi.domain.File> getSameDirectoryInformationAcrossTime(@RequestParam(value="path", defaultValue="/") String path, @RequestParam(value="volumeId") Long volumeId, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="indexingDate,desc") String sort) {
        return this.directoryService.getSameDirectoryInformationAcrossTime(path, volumeId, page, size, sort);
    }

    @GetMapping(value={"/statistics"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get statistic about a directory")
    public FileStatistics getDirectoryStatistics(@RequestParam(value="path", defaultValue="/") String path, @RequestParam(value="volumeId") Long volumeId) {
        return this.directoryService.getDirectoryStatistics(path, volumeId);
    }

    @GetMapping(value={"/hash/{hash}"})
    @Operation(summary="Get all the folders with a specific identification hash", description="Two folders have the same identification hash when they have the same sizes, creation dates, number of files and number of folders.")
    public PaginatedResult<io.dataintell.visionapi.domain.File> getFoldersByHash(@PathVariable(value="hash") String hash, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="name") String sort, @RequestParam(value="indexingDate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate indexingDate) {
        return this.fileService.getFilesByHash(hash, page, size, sort, indexingDate, true);
    }
}

