/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.domain.Configuration;
import io.dataintell.visionapi.service.ConfigurationService;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Hidden
@RequestMapping(value={"/configurations"})
@PreAuthorize(value="hasRole('ROLE_ADMIN')")
public class ConfigurationController {
    private final ConfigurationService configurationService;

    public ConfigurationController(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @GetMapping(value={""})
    @Operation(summary="Get a list of all configurations", hidden=true)
    public List<Configuration> getConfigurations() {
        return this.configurationService.getConfigurations();
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="Update a DataIntell configuration, such as scan cron schedule value", hidden=true)
    public Configuration updateConfiguration(@PathVariable(value="id") Long id, @RequestBody @Valid Configuration configuration) {
        return this.configurationService.updateConfiguration(id, configuration);
    }
}

