/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.domain.Bucket;
import io.dataintell.visionapi.domain.CloudCredentials;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.entity.AWSCredentialsEntity;
import io.dataintell.visionapi.service.BucketCredentialsService;
import io.dataintell.visionapi.service.BucketService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Buckets", description="Register cloud based bucket to be ingested. Bucket must support S3 standard.")
public class BucketController {
    private final BucketService bucketService;
    private final BucketCredentialsService credentialsService;

    public BucketController(BucketService bucketService, BucketCredentialsService credentialsService) {
        this.bucketService = bucketService;
        this.credentialsService = credentialsService;
    }

    @PostMapping(value={"v1/buckets"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Create bucket", description="Requires bucket credentials, so you must create them first. It also creates a placeholder volume")
    public Bucket create(@RequestBody @Valid Bucket bucket) {
        return this.bucketService.create(bucket);
    }

    @GetMapping(value={"v1/buckets"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all buckets", description="It will only get the ids of the bucket credentials that are linked to the buckets")
    public PaginatedResult<Bucket> getAll(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="name") String sort) {
        return this.bucketService.getAll(page, size, sort);
    }

    @GetMapping(value={"v1/buckets/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get bucket by id", description="It will only get the id of the bucket credentials that is linked to the bucket")
    public Bucket read(@PathVariable int id) {
        return this.bucketService.get(id);
    }

    @PutMapping(value={"v1/buckets/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Update bucket by id", description="It will also update the placeholder volume linked to the bucket")
    public Bucket update(@PathVariable int id, @RequestBody @Valid Bucket bucket) {
        return this.bucketService.update(id, bucket);
    }

    @DeleteMapping(value={"v1/buckets/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Delete bucket by id", description="It will also delete the placeholder volume linked to the bucket")
    public void delete(@PathVariable int id) {
        this.bucketService.delete(id);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PostMapping(value={"v1/bucket-credentials"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create bucket credentials", description="It will be used to create a bucket")
    public CloudCredentials createCredentials(@RequestBody @Valid CloudCredentials credentials) {
        return this.credentialsService.create(credentials);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @GetMapping(value={"v1/bucket-credentials"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all bucket credentials", description="It will only get the ids and names of the bucket credentials")
    public PaginatedResult<AWSCredentialsEntity> getAllCredentials(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="name") String sort) {
        return this.credentialsService.getAll(page, size, sort);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @GetMapping(value={"v1/bucket-credentials/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get bucket credentials by id", description="It will only get the id and name of the bucket credentials")
    public CloudCredentials getCredentials(@PathVariable int id) {
        return this.credentialsService.read(id);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @PutMapping(value={"v1/bucket-credentials/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update bucket credentials by id", description="Requires to enter all the informations of the bucket credentials")
    public CloudCredentials updateCredentials(@PathVariable int id, @RequestBody @Valid CloudCredentials credentials) {
        return this.credentialsService.update(id, credentials);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @DeleteMapping(value={"v1/bucket-credentials/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete bucket credentials by id", description="If a bucket is using the bucket credentials, it will fail")
    public void deleteCredentials(@PathVariable int id) {
        this.credentialsService.delete(id);
    }

    @PostMapping(value={"v1/buckets/names"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Get  names of buckets", description="Get names of buckets for current credentials. The namespace parameter is only used for Oracle bucket.")
    public List<String> getBucketNames(@RequestParam(value="credentialsId") int credentialsId, @RequestParam(value="region") String region, @RequestParam(value="namespace", required=false) String namespace) {
        return this.bucketService.getListOfBucketsByCredentials(credentialsId, region, namespace);
    }
}

