/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.domain.JwtAuthenticationResponse;
import io.dataintell.visionapi.domain.LoginRequest;
import io.dataintell.visionapi.security.JwtTokenProvider;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth"})
@Tag(name="Authentication", description="Use this endpoint to get an access token. The access token is needed to use any other endpoint of DataIntell Core API.")
@SecurityRequirements
public class AuthController {
    private static final Logger logger = LoggerFactory.getLogger(AuthController.class);
    private final AuthenticationManager authenticationManager;
    private final JwtTokenProvider tokenProvider;

    public AuthController(AuthenticationManager authenticationManager, JwtTokenProvider tokenProvider) {
        this.authenticationManager = authenticationManager;
        this.tokenProvider = tokenProvider;
    }

    @PostMapping(value={"/signin"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Authentication endpoint to get a bearer token", description="Use the value of access token to authenticate with the application.")
    public JwtAuthenticationResponse authenticateUser(@Valid @RequestBody LoginRequest loginRequest) {
        Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)loginRequest.getUsernameOrEmail(), (Object)loginRequest.getPassword()));
        SecurityContextHolder.getContext().setAuthentication(authentication);
        String jwt = this.tokenProvider.generateToken(authentication);
        logger.info(String.format("%s just logged in the application", loginRequest.getUsernameOrEmail()));
        return new JwtAuthenticationResponse(jwt);
    }
}

