/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.domain.ArchiwareP5Credential;
import io.dataintell.visionapi.domain.ArchiwareP5Index;
import io.dataintell.visionapi.domain.PaginatedResult;
import io.dataintell.visionapi.license.HasBundles;
import io.dataintell.visionapi.service.ArchiwareService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Archiware", description="Everything related to the Archiware integration")
public class ArchiwareController {
    public final ArchiwareService archiwareService;

    public ArchiwareController(ArchiwareService archiwareService) {
        this.archiwareService = archiwareService;
    }

    @GetMapping(value={"v1/archiwares/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get the Archiware P5 configuration by id", description="Get the Archiware P5 configuration with id passed in URL. It will also provide the volume id linked to the archiware configuration and the storage price set for this specific volume.")
    @HasBundles(value={"archiwareP5"})
    public ArchiwareP5Index read(@PathVariable Long id) {
        return this.archiwareService.get(id);
    }

    @GetMapping(value={"v1/archiwares"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all the Archiware P5 configurations.", description="Get all Archiware P5 configurations with pagination and sort parameter.")
    @HasBundles(value={"archiwareP5"})
    public PaginatedResult<ArchiwareP5Index> getAll(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="id") String sort, @RequestParam(value="direction", defaultValue="asc") String direction) {
        return this.archiwareService.getAll(page, size, sort, direction);
    }

    @PostMapping(value={"v1/archiwares"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Create an Archiware P5 Index.", description="Create an Archiware P5 index with a new volume and a storage price set for this specific volume.")
    @HasBundles(value={"archiwareP5"})
    public ArchiwareP5Index create(@RequestBody @Valid ArchiwareP5Index archiwareP5Index) {
        return this.archiwareService.create(archiwareP5Index);
    }

    @DeleteMapping(value={"v1/archiwares/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Delete an Archiware P5 index configuration by id", description="Delete an Archiware P5 index configuration by id with its linked volume.")
    @HasBundles(value={"archiwareP5"})
    public void delete(@PathVariable Long id) {
        this.archiwareService.deleteArchiwareP5Index(id);
    }

    @PutMapping(value={"v1/archiwares/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Update an Archiware P5 index configuration by id.", description="Update an Archiware P5 index configuration with its volume and storage price linked to the volume.")
    @HasBundles(value={"archiwareP5"})
    public ArchiwareP5Index update(@PathVariable Long id, @RequestBody @Valid ArchiwareP5Index archiwareP5Index) {
        return this.archiwareService.update(id, archiwareP5Index);
    }

    @GetMapping(value={"/v1/archiwares/indexes"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all the Archiware P5 indexes", description="Get a list of all Archiware P5 indexes for an URL, user and password")
    @HasBundles(value={"archiwareP5"})
    public List<String> getIndexes(@RequestBody @Valid ArchiwareP5Credential archiwareBasicConfiguration) {
        return this.archiwareService.getArchiwareIndexes(archiwareBasicConfiguration);
    }

    @GetMapping(value={"/v1/archiwares/credentials/{id}/indexes"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all the Archiware P5 indexes", description="Get a list of all Archiware P5 indexes for an Archiware P5 Credential")
    @HasBundles(value={"archiwareP5"})
    public List<String> getIndexes(@PathVariable Long id) {
        return this.archiwareService.getArchiwareIndexes(id);
    }

    @GetMapping(value={"/v1/archiwares/credentials"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all Archiware P5 credentials", description="Get a list of all Archiware P5 credentials")
    @HasBundles(value={"archiwareP5"})
    public PaginatedResult<ArchiwareP5Credential> getArchiwareP5Credentials(@RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="size", defaultValue="10") Integer size, @RequestParam(value="sort", defaultValue="name") String sort) {
        return this.archiwareService.getAllCredentials(page, size, sort);
    }

    @PostMapping(value={"/v1/archiwares/credentials"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create Archiware P5 credentials", description="Create an Archiware P5 Credential to connect to an Archiware P5 server")
    @HasBundles(value={"archiwareP5"})
    public ArchiwareP5Credential createArchiwareP5Credential(@RequestBody @Valid ArchiwareP5Credential archiwareP5Credential) {
        return this.archiwareService.create(archiwareP5Credential);
    }

    @DeleteMapping(value={"v1/archiwares/credentials/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Delete an Archiware P5 credential by id", description="Delete an Archiware P5 credential by id.")
    @HasBundles(value={"archiwareP5"})
    public void deleteArchiwareP5Credential(@PathVariable Long id) {
        this.archiwareService.deleteArchiwareP5Credential(id);
    }

    @PutMapping(value={"v1/archiwares/credentials/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Update an Archiware P5 credential by id.", description="Update an Archiware P5 credential to connect to an Archiware P5 server")
    @HasBundles(value={"archiwareP5"})
    public ArchiwareP5Credential updateArchiwareP5Credential(@PathVariable Long id, @RequestBody @Valid ArchiwareP5Credential archiwareP5Credential) {
        return this.archiwareService.update(id, archiwareP5Credential);
    }
}

