/*
 * Decompiled with CFR 0.152.
 */
package io.dataintell.visionapi.controller;

import io.dataintell.visionapi.service.IndexService;
import io.dataintell.visionapi.service.LogService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Administration", description="General purpose endpoints")
@RequestMapping(value={"/administration"})
public class AdministrationController {
    private static final Logger logger = LoggerFactory.getLogger(AdministrationController.class);
    private final IndexService indexService;
    private final LogService logService;

    public AdministrationController(IndexService indexService, LogService logService) {
        this.indexService = indexService;
        this.logService = logService;
    }

    @DeleteMapping(value={"/snapshots"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Force delete snapshots of indexed data based on configuration", description="The configurations are snapshot.numberOfDays and snapshot.keepFirstDayOfMonth")
    public void deleteSnapshotsBasedOnConfiguration() {
        this.indexService.deleteIndexBasedOnConfigurations();
    }

    @GetMapping(value={"/dates"})
    @Operation(summary="Get a list of snapshots dates indexed by DataIntell")
    public List<LocalDate> getAllCrawlDates() {
        return this.indexService.getAllScanDates();
    }

    @GetMapping(value={"/logs"})
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @Operation(summary="Download a zip containing all DataIntell logs for debugging")
    public ResponseEntity<?> getLogs() {
        try {
            ByteArrayResource zippedLogFolder = this.logService.getLogs();
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "attachment; filename=dataintell-logs.zip");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(headers)).contentLength(zippedLogFolder.contentLength()).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)zippedLogFolder);
        }
        catch (IOException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e);
        }
    }
}

